/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import io.prestosql.client.QueryResults;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.testing.assertions.Assert;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestQueryResource {
    private final HttpClient client = new JettyHttpClient();
    private TestingPrestoServer server = new TestingPrestoServer();

    @BeforeClass
    public void setup() {
        this.runToCompletion("SELECT 1");
        this.runToCompletion("SELECT 2");
        this.runToCompletion("SELECT x FROM y");
    }

    private void runToCompletion(String sql) {
        URI uri = HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl().resolve("/v1/statement")).build();
        Request request = Request.Builder.preparePost().setHeader("X-Presto-User", "user").setUri(uri).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)sql, (Charset)StandardCharsets.UTF_8)).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        while (queryResults.getNextUri() != null) {
            request = Request.Builder.prepareGet().setHeader("X-Presto-User", "user").setUri(queryResults.getNextUri()).build();
            queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        }
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testGetQueryInfos() {
        List<BasicQueryInfo> infos = this.getQueryInfos("/v1/query");
        Assert.assertEquals((int)infos.size(), (int)3);
        this.assertStateCounts(infos, 2, 1, 0);
        infos = this.getQueryInfos("/v1/query?state=finished");
        Assert.assertEquals((int)infos.size(), (int)2);
        this.assertStateCounts(infos, 2, 0, 0);
        infos = this.getQueryInfos("/v1/query?state=failed");
        Assert.assertEquals((int)infos.size(), (int)1);
        this.assertStateCounts(infos, 0, 1, 0);
        infos = this.getQueryInfos("/v1/query?state=running");
        Assert.assertEquals((int)infos.size(), (int)0);
        this.assertStateCounts(infos, 0, 0, 0);
    }

    private List<BasicQueryInfo> getQueryInfos(String path) {
        Request request = Request.Builder.prepareGet().setUri(this.server.resolve(path)).build();
        return (List)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(BasicQueryInfo.class)));
    }

    private void assertStateCounts(List<BasicQueryInfo> infos, int expectedFinished, int expectedFailed, int expectedRunning) {
        int failed = 0;
        int finished = 0;
        int running = 0;
        block5: for (BasicQueryInfo info : infos) {
            switch (info.getState()) {
                case FINISHED: {
                    ++finished;
                    continue block5;
                }
                case FAILED: {
                    ++failed;
                    continue block5;
                }
                case RUNNING: {
                    ++running;
                    continue block5;
                }
            }
            org.testng.Assert.fail((String)("Unexpected query state " + info.getState()));
        }
        Assert.assertEquals((int)failed, (int)expectedFailed);
        Assert.assertEquals((int)finished, (int)expectedFinished);
        Assert.assertEquals((int)running, (int)expectedRunning);
    }
}

