/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.prestosql.Session;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AllowAllAccessControl;
import io.prestosql.server.HttpRequestSessionContext;
import io.prestosql.server.MockHttpServletRequest;
import io.prestosql.server.QuerySessionSupplier;
import io.prestosql.server.SessionContext;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.sql.SqlEnvironmentConfig;
import io.prestosql.sql.SqlPath;
import io.prestosql.sql.SqlPathElement;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.transaction.InMemoryTransactionManager;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQuerySessionSupplier {
    private static final HttpServletRequest TEST_REQUEST = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Source", (Object)"testSource").put((Object)"X-Presto-Catalog", (Object)"testCatalog").put((Object)"X-Presto-Schema", (Object)"testSchema").put((Object)"X-Presto-Path", (Object)"testPath").put((Object)"X-Presto-Language", (Object)"zh-TW").put((Object)"X-Presto-Time-Zone", (Object)"Asia/Taipei").put((Object)"X-Presto-Client-Info", (Object)"client-info").put((Object)"X-Presto-Client-Tags", (Object)"tag1,tag2 ,tag3, tag2").put((Object)"X-Presto-Session", (Object)"query_max_memory=1GB").put((Object)"X-Presto-Session", (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)"X-Presto-Prepared-Statement", (Object)"query1=select * from foo,query2=select * from bar").build(), "testRemote");

    @Test
    public void testCreateSession() {
        HttpRequestSessionContext context = new HttpRequestSessionContext(TEST_REQUEST);
        QuerySessionSupplier sessionSupplier = new QuerySessionSupplier(InMemoryTransactionManager.createTestTransactionManager(), (AccessControl)new AllowAllAccessControl(), new SessionPropertyManager(), new SqlEnvironmentConfig());
        Session session = sessionSupplier.createSession(new QueryId("test_query_id"), (SessionContext)context);
        Assert.assertEquals((Object)session.getQueryId(), (Object)new QueryId("test_query_id"));
        Assert.assertEquals((String)session.getUser(), (String)"testUser");
        Assert.assertEquals((String)((String)session.getSource().get()), (String)"testSource");
        Assert.assertEquals((String)((String)session.getCatalog().get()), (String)"testCatalog");
        Assert.assertEquals((String)((String)session.getSchema().get()), (String)"testSchema");
        Assert.assertEquals((String)((String)session.getPath().getRawPath().get()), (String)"testPath");
        Assert.assertEquals((Object)session.getLocale(), (Object)Locale.TAIWAN);
        Assert.assertEquals((Object)session.getTimeZoneKey(), (Object)TimeZoneKey.getTimeZoneKey((String)"Asia/Taipei"));
        Assert.assertEquals((String)((String)session.getRemoteUserAddress().get()), (String)"testRemote");
        Assert.assertEquals((String)((String)session.getClientInfo().get()), (String)"client-info");
        Assert.assertEquals((Set)session.getClientTags(), (Set)ImmutableSet.of((Object)"tag1", (Object)"tag2", (Object)"tag3"));
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((Map)session.getPreparedStatements(), (Map)ImmutableMap.builder().put((Object)"query1", (Object)"select * from foo").put((Object)"query2", (Object)"select * from bar").build());
    }

    @Test
    public void testEmptyClientTags() {
        MockHttpServletRequest request1 = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").build(), "remoteAddress");
        HttpRequestSessionContext context1 = new HttpRequestSessionContext((HttpServletRequest)request1);
        Assert.assertEquals((Set)context1.getClientTags(), (Set)ImmutableSet.of());
        MockHttpServletRequest request2 = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Client-Tags", (Object)"").build(), "remoteAddress");
        HttpRequestSessionContext context2 = new HttpRequestSessionContext((HttpServletRequest)request2);
        Assert.assertEquals((Set)context2.getClientTags(), (Set)ImmutableSet.of());
    }

    @Test
    public void testClientCapabilities() {
        MockHttpServletRequest request1 = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Client-Capabilities", (Object)"foo, bar").build(), "remoteAddress");
        HttpRequestSessionContext context1 = new HttpRequestSessionContext((HttpServletRequest)request1);
        Assert.assertEquals((Set)context1.getClientCapabilities(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar"));
        MockHttpServletRequest request2 = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").build(), "remoteAddress");
        HttpRequestSessionContext context2 = new HttpRequestSessionContext((HttpServletRequest)request2);
        Assert.assertEquals((Set)context2.getClientCapabilities(), (Set)ImmutableSet.of());
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testInvalidTimeZone() {
        MockHttpServletRequest request = new MockHttpServletRequest((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)"X-Presto-User", (Object)"testUser").put((Object)"X-Presto-Time-Zone", (Object)"unknown_timezone").build(), "testRemote");
        HttpRequestSessionContext context = new HttpRequestSessionContext((HttpServletRequest)request);
        QuerySessionSupplier sessionSupplier = new QuerySessionSupplier(InMemoryTransactionManager.createTestTransactionManager(), (AccessControl)new AllowAllAccessControl(), new SessionPropertyManager(), new SqlEnvironmentConfig());
        sessionSupplier.createSession(new QueryId("test_query_id"), (SessionContext)context);
    }

    @Test
    public void testSqlPathCreation() {
        ImmutableList.Builder correctValues = ImmutableList.builder();
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("normal")), new Identifier("schema")));
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("who.uses.periods")), new Identifier("in.schema.names")));
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("same,deal")), new Identifier("with,commas")));
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("aterrible")), new Identifier("thing!@#$%^&*()")));
        ImmutableList expected = correctValues.build();
        SqlPath path = new SqlPath(Optional.of("normal.schema,\"who.uses.periods\".\"in.schema.names\",\"same,deal\".\"with,commas\",aterrible.\"thing!@#$%^&*()\""));
        Assert.assertEquals((Collection)path.getParsedPath(), (Collection)expected);
        Assert.assertEquals((String)path.toString(), (String)Joiner.on((String)", ").join((Iterable)expected));
    }
}

