/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.server.security.KerberosConfig;
import io.prestosql.server.security.KerberosNameType;
import java.io.File;
import java.util.Map;
import org.testng.annotations.Test;

public class TestKerberosConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((KerberosConfig)ConfigAssertions.recordDefaults(KerberosConfig.class)).setKerberosConfig(null).setServiceName(null).setKeytab(null).setPrincipalHostname(null).setNameType(KerberosNameType.HOSTBASED_SERVICE));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http.authentication.krb5.config", (Object)"/etc/krb5.conf").put((Object)"http.server.authentication.krb5.service-name", (Object)"airlift").put((Object)"http.server.authentication.krb5.keytab", (Object)"/tmp/presto.keytab").put((Object)"http.server.authentication.krb5.principal-hostname", (Object)"presto.prestosql.io").put((Object)"http.server.authentication.krb5.name-type", (Object)"USER_NAME").build();
        KerberosConfig expected = new KerberosConfig().setKerberosConfig(new File("/etc/krb5.conf")).setServiceName("airlift").setKeytab(new File("/tmp/presto.keytab")).setPrincipalHostname("presto.prestosql.io").setNameType(KerberosNameType.USER_NAME);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

