/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.prestosql.RowPagesBuilder;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.PagesSerdeFactory;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.operator.PageAssertions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.FileSingleStreamSpillerFactory;
import io.prestosql.spiller.GenericSpillerFactory;
import io.prestosql.spiller.SingleStreamSpillerFactory;
import io.prestosql.spiller.Spiller;
import io.prestosql.spiller.SpillerFactory;
import io.prestosql.spiller.SpillerStats;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.type.TypeRegistry;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestBinaryFileSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BigintType.BIGINT);
    private BlockEncodingSerde blockEncodingSerde;
    private File spillPath = Files.createTempDir();
    private SpillerStats spillerStats;
    private FileSingleStreamSpillerFactory singleStreamSpillerFactory;
    private SpillerFactory factory;
    private PagesSerde pagesSerde;
    private AggregatedMemoryContext memoryContext;

    @BeforeMethod
    public void setUp() {
        this.blockEncodingSerde = new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]);
        this.spillerStats = new SpillerStats();
        FeaturesConfig featuresConfig = new FeaturesConfig();
        featuresConfig.setSpillerSpillPaths(this.spillPath.getAbsolutePath());
        featuresConfig.setSpillMaxUsedSpaceThreshold(1.0);
        this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(this.blockEncodingSerde, this.spillerStats, featuresConfig);
        this.factory = new GenericSpillerFactory((SingleStreamSpillerFactory)this.singleStreamSpillerFactory);
        PagesSerdeFactory pagesSerdeFactory = new PagesSerdeFactory(Objects.requireNonNull(this.blockEncodingSerde, "blockEncodingSerde is null"), false);
        this.pagesSerde = pagesSerdeFactory.createPagesSerde();
        this.memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.singleStreamSpillerFactory.destroy();
        MoreFiles.deleteRecursively((Path)this.spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testFileSpiller() throws Exception {
        try (Spiller spiller = this.factory.create(TYPES, bytes -> {}, this.memoryContext);){
            this.testSimpleSpiller(spiller);
        }
    }

    @Test
    public void testFileVarbinarySpiller() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        BlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        col2.writeLong(Double.doubleToLongBits(43.0)).closeEntry();
        col3.writeLong(Double.doubleToLongBits(43.0)).writeLong(1L).closeEntry();
        Page page = new Page(new Block[]{col1.build(), col2.build(), col3.build()});
        try (Spiller spiller = this.factory.create(TYPES, bytes -> {}, this.memoryContext);){
            this.testSpiller((List<Type>)types, spiller, new List[]{ImmutableList.of((Object)page)});
        }
    }

    private void testSimpleSpiller(Spiller spiller) throws ExecutionException, InterruptedException {
        RowPagesBuilder builder = RowPagesBuilder.rowPagesBuilder(TYPES);
        builder.addSequencePage(10, 0, 5, 10, 15);
        builder.pageBreak();
        builder.addSequencePage(10, 0, -5, -10, -15);
        List<Page> firstSpill = builder.build();
        builder = RowPagesBuilder.rowPagesBuilder(TYPES);
        builder.addSequencePage(10, 10, 15, 20, 25);
        builder.pageBreak();
        builder.addSequencePage(10, -10, -15, -20, -25);
        List<Page> secondSpill = builder.build();
        this.testSpiller(TYPES, spiller, firstSpill, secondSpill);
    }

    private void testSpiller(List<Type> types, Spiller spiller, List<Page> ... spills) throws ExecutionException, InterruptedException {
        long spilledBytesBefore = this.spillerStats.getTotalSpilledBytes();
        long spilledBytes = 0L;
        Assert.assertEquals((long)this.memoryContext.getBytes(), (long)0L);
        for (List<Page> spill : spills) {
            spilledBytes += spill.stream().mapToLong(page -> this.pagesSerde.serialize(page).getSizeInBytes()).sum();
            spiller.spill(spill.iterator()).get();
        }
        Assert.assertEquals((long)(this.spillerStats.getTotalSpilledBytes() - spilledBytesBefore), (long)spilledBytes);
        Assert.assertEquals((long)this.memoryContext.getBytes(), (long)(spills.length * 4096));
        List actualSpills = spiller.getSpills();
        Assert.assertEquals((int)actualSpills.size(), (int)spills.length);
        for (int i = 0; i < actualSpills.size(); ++i) {
            ImmutableList actualSpill = ImmutableList.copyOf((Iterator)((Iterator)actualSpills.get(i)));
            List<Page> expectedSpill = spills[i];
            Assert.assertEquals((int)actualSpill.size(), (int)expectedSpill.size());
            for (int j = 0; j < actualSpill.size(); ++j) {
                PageAssertions.assertPageEquals(types, (Page)actualSpill.get(j), expectedSpill.get(j));
            }
        }
        spiller.close();
        Assert.assertEquals((long)this.memoryContext.getBytes(), (long)0L);
    }
}

