/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spiller.FileSingleStreamSpillerFactory;
import io.prestosql.spiller.SingleStreamSpiller;
import io.prestosql.spiller.SpillerStats;
import io.prestosql.type.TypeRegistry;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFileSingleStreamSpillerFactory {
    private Closer closer;
    private ListeningExecutorService executor;
    private File spillPath1;
    private File spillPath2;

    @BeforeMethod
    public void setUp() {
        this.closer = Closer.create();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.closer.register(() -> this.executor.shutdownNow());
        this.spillPath1 = com.google.common.io.Files.createTempDir();
        this.closer.register(() -> MoreFiles.deleteRecursively((Path)this.spillPath1.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.spillPath2 = com.google.common.io.Files.createTempDir();
        this.closer.register(() -> MoreFiles.deleteRecursively((Path)this.spillPath2.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.closer.close();
    }

    @Test
    public void testDistributesSpillOverPaths() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, (BlockEncodingSerde)blockEncodingSerde, new SpillerStats(), (List)spillPaths, 1.0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
        Page page = this.buildPage();
        ArrayList<SingleStreamSpiller> spillers = new ArrayList<SingleStreamSpiller>();
        for (int i = 0; i < 10; ++i) {
            SingleStreamSpiller singleStreamSpiller = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
            Futures.getUnchecked((Future)singleStreamSpiller.spill(page));
            spillers.add(singleStreamSpiller);
        }
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)5);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)5);
        spillers.forEach(SingleStreamSpiller::close);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        return new Page(new Block[]{col1.build()});
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="No free space available for spill")
    public void throwsIfNoDiskSpace() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, (BlockEncodingSerde)blockEncodingSerde, new SpillerStats(), (List)spillPaths, 0.0);
        spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="No spill paths configured")
    public void throwIfNoSpillPaths() {
        List spillPaths = Collections.emptyList();
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), new SpillerStats(), spillPaths, 1.0);
        spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
    }

    @Test
    public void testCleanupOldSpillFiles() throws Exception {
        BlockEncodingManager blockEncodingSerde = new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        this.spillPath1.mkdirs();
        this.spillPath2.mkdirs();
        Files.createTempFile(this.spillPath1.toPath(), "spill", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath1.toPath(), "spill", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath1.toPath(), "spill", "blah", new FileAttribute[0]);
        Files.createTempFile(this.spillPath2.toPath(), "spill", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath2.toPath(), "blah", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath2.toPath(), "blah", "blah", new FileAttribute[0]);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)3);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)3);
        FileSingleStreamSpillerFactory spillerFactory = new FileSingleStreamSpillerFactory(this.executor, (BlockEncodingSerde)blockEncodingSerde, new SpillerStats(), (List)spillPaths, 1.0);
        spillerFactory.cleanupOldSpillFiles();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)1);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)2);
    }
}

