/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.StringLiteral;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestExpressionUtils {
    @Test
    public void testAnd() {
        Identifier a = TestExpressionUtils.name("a");
        Identifier b = TestExpressionUtils.name("b");
        Identifier c = TestExpressionUtils.name("c");
        Identifier d = TestExpressionUtils.name("d");
        Identifier e = TestExpressionUtils.name("e");
        Assert.assertEquals((Object)ExpressionUtils.and((Expression[])new Expression[]{a, b, c, d, e}), (Object)this.and((Expression)this.and((Expression)this.and((Expression)a, (Expression)b), (Expression)this.and((Expression)c, (Expression)d)), (Expression)e));
        Assert.assertEquals((Object)ExpressionUtils.combineConjuncts((Expression[])new Expression[]{a, b, a, c, d, c, e}), (Object)this.and((Expression)this.and((Expression)this.and((Expression)a, (Expression)b), (Expression)this.and((Expression)c, (Expression)d)), (Expression)e));
    }

    @Test
    public void testNormalize() {
        TestExpressionUtils.assertNormalize((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1")));
        TestExpressionUtils.assertNormalize((Expression)new IsNullPredicate((Expression)TestExpressionUtils.name("a")));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new LikePredicate((Expression)TestExpressionUtils.name("a"), (Expression)new StringLiteral("x%"), Optional.empty())));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1")));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1")));
        TestExpressionUtils.assertNormalize((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestExpressionUtils.name("a"), (Expression)new LongLiteral("1"))));
    }

    private static void assertNormalize(Expression expression) {
        TestExpressionUtils.assertNormalize(expression, expression);
    }

    private static void assertNormalize(Expression expression, Expression normalized) {
        Assert.assertEquals((Object)ExpressionUtils.normalize((Expression)expression), (Object)normalized);
    }

    private static Identifier name(String name) {
        return new Identifier(name);
    }

    private LogicalBinaryExpression and(Expression left, Expression right) {
        return new LogicalBinaryExpression(LogicalBinaryExpression.Operator.AND, left, right);
    }
}

