/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.sql.analyzer.ExpressionAnalyzer;
import io.prestosql.sql.analyzer.Scope;
import io.prestosql.sql.planner.ExpressionInterpreter;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.NoOpSymbolResolver;
import io.prestosql.sql.planner.SymbolResolver;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SqlToRowExpressionTranslator;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.testing.assertions.Assert;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSqlToRowExpressionTranslator {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final LiteralEncoder literalEncoder = new LiteralEncoder(this.metadata.getBlockEncodingSerde());

    @Test(timeOut=10000L)
    public void testPossibleExponentialOptimizationTime() {
        LongLiteral expression = new LongLiteral("1");
        ImmutableMap.Builder types = ImmutableMap.builder();
        types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            expression = new CoalesceExpression((Expression)expression, (Expression)new LongLiteral("2"), new Expression[0]);
            types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        }
        this.translateAndOptimize((Expression)expression, (Map<NodeRef<Expression>, Type>)types.build());
    }

    @Test
    public void testOptimizeDecimalLiteral() {
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(7,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("DECIMAL '42'")), (Object)Expressions.constant((Object)42L, (Type)DecimalType.createDecimalType((int)2, (int)0)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))")), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(this.simplifyExpression(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))"))), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(35,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("DECIMAL '123456789012345678901234567890'")), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890")), (Type)DecimalType.createDecimalType((int)30, (int)0)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))")), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(this.simplifyExpression(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))"))), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
    }

    private RowExpression translateAndOptimize(Expression expression) {
        return this.translateAndOptimize(expression, this.getExpressionTypes(expression));
    }

    private RowExpression translateAndOptimize(Expression expression, Map<NodeRef<Expression>, Type> types) {
        return SqlToRowExpressionTranslator.translate((Expression)expression, (FunctionKind)FunctionKind.SCALAR, types, (Map)ImmutableMap.of(), (FunctionRegistry)this.metadata.getFunctionRegistry(), (TypeManager)this.metadata.getTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (boolean)true);
    }

    private Expression simplifyExpression(Expression expression) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(expression);
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer((Expression)expression, (Metadata)this.metadata, (Session)SessionTestUtils.TEST_SESSION, expressionTypes);
        Object value = interpreter.optimize((SymbolResolver)NoOpSymbolResolver.INSTANCE);
        return this.literalEncoder.toExpression(value, expressionTypes.get(NodeRef.of((Node)expression)));
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression) {
        ExpressionAnalyzer expressionAnalyzer = ExpressionAnalyzer.createWithoutSubqueries((FunctionRegistry)this.metadata.getFunctionRegistry(), (TypeManager)this.metadata.getTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (TypeProvider)TypeProvider.empty(), Collections.emptyList(), node -> new IllegalStateException("Unexpected node: %s" + node), (WarningCollector)WarningCollector.NOOP, (boolean)false);
        expressionAnalyzer.analyze(expression, Scope.create());
        return expressionAnalyzer.getExpressionTypes();
    }
}

