/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import io.prestosql.operator.aggregation.histogram.HistogramGroupImplementation;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.RegexLibrary;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FeaturesConfig)ConfigAssertions.recordDefaults(FeaturesConfig.class)).setCpuCostWeight(75.0).setMemoryCostWeight(10.0).setNetworkCostWeight(15.0).setDistributedIndexJoinsEnabled(false).setJoinDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED).setJoinMaxBroadcastTableSize(null).setGroupedExecutionEnabled(false).setDynamicScheduleForGroupedExecutionEnabled(false).setConcurrentLifespansPerTask(0).setFastInequalityJoins(true).setColocatedJoinsEnabled(false).setSpatialJoinsEnabled(true).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS).setMaxReorderedJoins(9).setRedistributeWrites(true).setScaleWriters(false).setWriterMinSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setOptimizeMetadataQueries(false).setOptimizeHashGeneration(true).setPushTableWriteThroughUnion(true).setDictionaryAggregation(false).setRegexLibrary(RegexLibrary.JONI).setRe2JDfaStatesLimit(Integer.MAX_VALUE).setRe2JDfaRetries(5).setSpillEnabled(false).setSpillOrderBy(true).setSpillWindowOperator(true).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setSpillerSpillPaths("").setSpillerThreads(4).setSpillMaxUsedSpaceThreshold(0.9).setMemoryRevokingThreshold(0.9).setMemoryRevokingTarget(0.5).setOptimizeMixedDistinctAggregations(false).setIterativeOptimizerEnabled(true).setIterativeOptimizerTimeout(new Duration(3.0, TimeUnit.MINUTES)).setEnableStatsCalculator(true).setIgnoreStatsCalculatorFailures(true).setDefaultFilterFactorEnabled(false).setEnableForcedExchangeBelowGroupId(true).setExchangeCompressionEnabled(false).setLegacyTimestamp(true).setEnableIntermediateAggregations(false).setPushAggregationThroughJoin(true).setParseDecimalLiteralsAsDouble(false).setForceSingleNodeOutput(true).setPagesIndexEagerCompactionEnabled(false).setFilterAndProjectMinOutputPageSize(new DataSize(500.0, DataSize.Unit.KILOBYTE)).setFilterAndProjectMinOutputPageRowCount(256).setUseMarkDistinct(true).setPreferPartialAggregation(true).setOptimizeTopNRowNumber(true).setHistogramGroupImplementation(HistogramGroupImplementation.NEW).setArrayAggGroupImplementation(ArrayAggGroupImplementation.NEW).setMultimapAggGroupImplementation(MultimapAggGroupImplementation.NEW).setDistributedSortEnabled(true).setMaxGroupingSets(2048).setWorkProcessorPipelines(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cpu-cost-weight", (Object)"0.4").put((Object)"memory-cost-weight", (Object)"0.3").put((Object)"network-cost-weight", (Object)"0.2").put((Object)"experimental.iterative-optimizer-enabled", (Object)"false").put((Object)"experimental.iterative-optimizer-timeout", (Object)"10s").put((Object)"experimental.enable-stats-calculator", (Object)"false").put((Object)"optimizer.ignore-stats-calculator-failures", (Object)"false").put((Object)"optimizer.default-filter-factor-enabled", (Object)"true").put((Object)"enable-forced-exchange-below-group-id", (Object)"false").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"join-distribution-type", (Object)"BROADCAST").put((Object)"join-max-broadcast-table-size", (Object)"42GB").put((Object)"grouped-execution-enabled", (Object)"true").put((Object)"dynamic-schedule-for-grouped-execution", (Object)"true").put((Object)"concurrent-lifespans-per-task", (Object)"1").put((Object)"fast-inequality-joins", (Object)"false").put((Object)"colocated-joins-enabled", (Object)"true").put((Object)"spatial-joins-enabled", (Object)"false").put((Object)"optimizer.join-reordering-strategy", (Object)"NONE").put((Object)"optimizer.max-reordered-joins", (Object)"5").put((Object)"redistribute-writes", (Object)"false").put((Object)"scale-writers", (Object)"true").put((Object)"writer-min-size", (Object)"42GB").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").put((Object)"optimizer.optimize-hash-generation", (Object)"false").put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true").put((Object)"optimizer.push-table-write-through-union", (Object)"false").put((Object)"optimizer.dictionary-aggregation", (Object)"true").put((Object)"optimizer.push-aggregation-through-join", (Object)"false").put((Object)"regex-library", (Object)"RE2J").put((Object)"re2j.dfa-states-limit", (Object)"42").put((Object)"re2j.dfa-retries", (Object)"42").put((Object)"experimental.spill-enabled", (Object)"true").put((Object)"experimental.spill-order-by", (Object)"false").put((Object)"experimental.spill-window-operator", (Object)"false").put((Object)"experimental.aggregation-operator-unspill-memory-limit", (Object)"100MB").put((Object)"experimental.spiller-spill-path", (Object)"/tmp/custom/spill/path1,/tmp/custom/spill/path2").put((Object)"experimental.spiller-threads", (Object)"42").put((Object)"experimental.spiller-max-used-space-threshold", (Object)"0.8").put((Object)"experimental.memory-revoking-threshold", (Object)"0.2").put((Object)"experimental.memory-revoking-target", (Object)"0.8").put((Object)"exchange.compression-enabled", (Object)"true").put((Object)"deprecated.legacy-timestamp", (Object)"false").put((Object)"optimizer.enable-intermediate-aggregations", (Object)"true").put((Object)"parse-decimal-literals-as-double", (Object)"true").put((Object)"optimizer.force-single-node-output", (Object)"false").put((Object)"pages-index.eager-compaction-enabled", (Object)"true").put((Object)"experimental.filter-and-project-min-output-page-size", (Object)"1MB").put((Object)"experimental.filter-and-project-min-output-page-row-count", (Object)"2048").put((Object)"histogram.implementation", (Object)"LEGACY").put((Object)"arrayagg.implementation", (Object)"LEGACY").put((Object)"multimapagg.implementation", (Object)"LEGACY").put((Object)"optimizer.use-mark-distinct", (Object)"false").put((Object)"optimizer.prefer-partial-aggregation", (Object)"false").put((Object)"optimizer.optimize-top-n-row-number", (Object)"false").put((Object)"distributed-sort", (Object)"false").put((Object)"analyzer.max-grouping-sets", (Object)"2047").put((Object)"experimental.work-processor-pipelines", (Object)"true").build();
        FeaturesConfig expected = new FeaturesConfig().setCpuCostWeight(0.4).setMemoryCostWeight(0.3).setNetworkCostWeight(0.2).setIterativeOptimizerEnabled(false).setIterativeOptimizerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setEnableStatsCalculator(false).setIgnoreStatsCalculatorFailures(false).setEnableForcedExchangeBelowGroupId(false).setDistributedIndexJoinsEnabled(true).setJoinDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST).setJoinMaxBroadcastTableSize(new DataSize(42.0, DataSize.Unit.GIGABYTE)).setGroupedExecutionEnabled(true).setDynamicScheduleForGroupedExecutionEnabled(true).setConcurrentLifespansPerTask(1).setFastInequalityJoins(false).setColocatedJoinsEnabled(true).setSpatialJoinsEnabled(false).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.NONE).setMaxReorderedJoins(5).setRedistributeWrites(false).setScaleWriters(true).setWriterMinSize(new DataSize(42.0, DataSize.Unit.GIGABYTE)).setOptimizeMetadataQueries(true).setOptimizeHashGeneration(false).setOptimizeMixedDistinctAggregations(true).setPushTableWriteThroughUnion(false).setDictionaryAggregation(true).setPushAggregationThroughJoin(false).setRegexLibrary(RegexLibrary.RE2J).setRe2JDfaStatesLimit(42).setRe2JDfaRetries(42).setSpillEnabled(true).setSpillOrderBy(false).setSpillWindowOperator(false).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setSpillerSpillPaths("/tmp/custom/spill/path1,/tmp/custom/spill/path2").setSpillerThreads(42).setSpillMaxUsedSpaceThreshold(0.8).setMemoryRevokingThreshold(0.2).setMemoryRevokingTarget(0.8).setExchangeCompressionEnabled(true).setLegacyTimestamp(false).setEnableIntermediateAggregations(true).setParseDecimalLiteralsAsDouble(true).setForceSingleNodeOutput(false).setPagesIndexEagerCompactionEnabled(true).setFilterAndProjectMinOutputPageSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setFilterAndProjectMinOutputPageRowCount(2048).setUseMarkDistinct(false).setPreferPartialAggregation(false).setOptimizeTopNRowNumber(false).setHistogramGroupImplementation(HistogramGroupImplementation.LEGACY).setArrayAggGroupImplementation(ArrayAggGroupImplementation.LEGACY).setMultimapAggGroupImplementation(MultimapAggGroupImplementation.LEGACY).setDistributedSortEnabled(false).setMaxGroupingSets(2047).setDefaultFilterFactorEnabled(true).setWorkProcessorPipelines(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*\\Qexperimental.spiller-spill-path must be configured when experimental.spill-enabled is set to true\\E.*")
    public void testValidateSpillConfiguredIfEnabled() {
        new ConfigurationFactory((Map)ImmutableMap.of((Object)"experimental.spill-enabled", (Object)"true")).build(FeaturesConfig.class);
    }
}

