/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.SequencePageBuilder;
import io.prestosql.Session;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.index.PageRecordSet;
import io.prestosql.operator.project.CursorProcessor;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.operator.scalar.FunctionAssertions;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.connector.RecordSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.SqlToRowExpressionTranslator;
import io.prestosql.sql.tree.Expression;
import io.prestosql.testing.TestingSession;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=10)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class PageProcessorBenchmark {
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeAnalyzer TYPE_ANALYZER = new TypeAnalyzer(new SqlParser(), METADATA);
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final int POSITIONS = 1024;
    private final DriverYieldSignal yieldSignal = new DriverYieldSignal();
    private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
    private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
    private CursorProcessor cursorProcessor;
    private PageProcessor pageProcessor;
    private Page inputPage;
    private RecordSet recordSet;
    private List<Type> types;
    @Param(value={"2", "4", "8", "16", "32"})
    int columnCount;
    @Param(value={"varchar", "bigint"})
    String type;
    @Param(value={"false", "true"})
    boolean dictionaryBlocks;

    @Setup
    public void setup() {
        Type type = TYPE_MAP.get(this.type);
        for (int i = 0; i < this.columnCount; ++i) {
            Symbol symbol = new Symbol(type.getDisplayName().toLowerCase(Locale.ENGLISH) + i);
            this.symbolTypes.put(symbol, type);
            this.sourceLayout.put(symbol, i);
        }
        List<RowExpression> projections = this.getProjections(type);
        this.types = projections.stream().map(RowExpression::getType).collect(Collectors.toList());
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        this.inputPage = PageProcessorBenchmark.createPage(this.types, this.dictionaryBlocks);
        this.pageProcessor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler).compilePageProcessor(Optional.of(this.getFilter(type)), projections).get();
        this.recordSet = new PageRecordSet(this.types, this.inputPage);
        this.cursorProcessor = (CursorProcessor)new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler).compileCursorProcessor(Optional.of(this.getFilter(type)), projections, (Object)"key").get();
    }

    @Benchmark
    public Page rowOriented() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        this.cursorProcessor.process(null, this.yieldSignal, this.recordSet.cursor(), pageBuilder);
        return pageBuilder.build();
    }

    @Benchmark
    public List<Optional<Page>> columnOriented() {
        return ImmutableList.copyOf((Iterator)this.pageProcessor.process(null, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), this.inputPage));
    }

    private RowExpression getFilter(Type type) {
        if (type == VarcharType.VARCHAR) {
            return this.rowExpression("cast(varchar0 as bigint) % 2 = 0");
        }
        if (type == BigintType.BIGINT) {
            return this.rowExpression("bigint0 % 2 = 0");
        }
        throw new IllegalArgumentException("filter not supported for type : " + type);
    }

    private List<RowExpression> getProjections(Type type) {
        ImmutableList.Builder builder;
        block3: {
            block2: {
                builder = ImmutableList.builder();
                if (type != BigintType.BIGINT) break block2;
                for (int i = 0; i < this.columnCount; ++i) {
                    builder.add((Object)this.rowExpression("bigint" + i + " + 5"));
                }
                break block3;
            }
            if (type != VarcharType.VARCHAR) break block3;
            for (int i = 0; i < this.columnCount; ++i) {
                builder.add((Object)this.rowExpression("concat(varchar" + i + ", 'foo')"));
            }
        }
        return builder.build();
    }

    private RowExpression rowExpression(String value) {
        Expression expression = FunctionAssertions.createExpression(value, METADATA, TypeProvider.copyOf(this.symbolTypes));
        Map expressionTypes = TYPE_ANALYZER.getTypes(TEST_SESSION, TypeProvider.copyOf(this.symbolTypes), expression);
        return SqlToRowExpressionTranslator.translate((Expression)expression, (FunctionKind)FunctionKind.SCALAR, (Map)expressionTypes, this.sourceLayout, (FunctionRegistry)METADATA.getFunctionRegistry(), (TypeManager)METADATA.getTypeManager(), (Session)TEST_SESSION, (boolean)true);
    }

    private static Page createPage(List<? extends Type> types, boolean dictionary) {
        if (dictionary) {
            return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, 1024);
        }
        return SequencePageBuilder.createSequencePage(types, 1024);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + PageProcessorBenchmark.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

