/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.PageAssertions;
import io.prestosql.operator.PagesHashStrategy;
import io.prestosql.operator.SimplePagesHashStrategy;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.JoinCompiler;
import io.prestosql.type.TypeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestJoinCompiler {
    private static final JoinCompiler joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
    private static final FunctionRegistry functionRegistry = MetadataManager.createTestMetadataManager().getFunctionRegistry();

    @DataProvider(name="hashEnabledValues")
    public static Object[][] hashEnabledValuesProvider() {
        return new Object[][]{{true}, {false}};
    }

    @Test(dataProvider="hashEnabledValues")
    public void testSingleChannel(boolean hashEnabled) {
        ImmutableList joinTypes = ImmutableList.of((Object)VarcharType.VARCHAR);
        List joinChannels = Ints.asList((int[])new int[]{0});
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)joinTypes, joinChannels);
        ImmutableList channel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        OptionalInt hashChannel = OptionalInt.empty();
        ImmutableList channels = ImmutableList.of((Object)channel);
        if (hashEnabled) {
            ImmutableList.Builder hashChannelBuilder = ImmutableList.builder();
            for (Block block : channel) {
                hashChannelBuilder.add((Object)TypeUtils.getHashBlock((List)joinTypes, (Block[])new Block[]{block}));
            }
            hashChannel = OptionalInt.of(1);
            channels = ImmutableList.of((Object)channel, (Object)hashChannelBuilder.build());
        }
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels, hashChannel);
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)1);
        for (int leftBlockIndex = 0; leftBlockIndex < channel.size(); ++leftBlockIndex) {
            Block leftBlock = (Block)channel.get(leftBlockIndex);
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
            for (int leftBlockPosition = 0; leftBlockPosition < leftBlock.getPositionCount(); ++leftBlockPosition) {
                boolean expected;
                int rightBlockPosition;
                Block rightBlock;
                int rightBlockIndex;
                Assert.assertEquals((long)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (long)TypeUtils.hashPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                    rightBlock = (Block)channel.get(rightBlockIndex);
                    for (rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        expected = TypeUtils.positionEqualsPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition, (Block)rightBlock, (int)rightBlockPosition);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.rowEqualsRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRowIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                    }
                }
                for (rightBlockIndex = 0; rightBlockIndex < channel.size(); ++rightBlockIndex) {
                    rightBlock = (Block)channel.get(rightBlockIndex);
                    for (rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        expected = TypeUtils.positionEqualsPosition((Type)VarcharType.VARCHAR, (Block)leftBlock, (int)leftBlockPosition, (Block)rightBlock, (int)rightBlockPosition);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.rowEqualsRow(leftBlockPosition, new Page(new Block[]{leftBlock}), rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRowIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockPosition, new Page(new Block[]{rightBlock})), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expected);
                    }
                }
                pageBuilder.declarePosition();
                hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
            }
            BlockAssertions.assertBlockEquals((Type)VarcharType.VARCHAR, pageBuilder.build().getBlock(0), leftBlock);
        }
    }

    @Test(dataProvider="hashEnabledValues")
    public void testMultiChannel(boolean hashEnabled) {
        JoinCompiler joinCompiler = new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager());
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR);
        ImmutableList joinTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN);
        ImmutableList outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR);
        List joinChannels = Ints.asList((int[])new int[]{1, 2, 3, 4});
        List outputChannels = Ints.asList((int[])new int[]{1, 2, 3, 4, 0});
        ImmutableList extraChannel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        ImmutableList varcharChannel = ImmutableList.of((Object)BlockAssertions.createStringSequenceBlock(10, 20), (Object)BlockAssertions.createStringSequenceBlock(20, 30), (Object)BlockAssertions.createStringSequenceBlock(15, 25));
        ImmutableList longChannel = ImmutableList.of((Object)BlockAssertions.createLongSequenceBlock(10, 20), (Object)BlockAssertions.createLongSequenceBlock(20, 30), (Object)BlockAssertions.createLongSequenceBlock(15, 25));
        ImmutableList doubleChannel = ImmutableList.of((Object)BlockAssertions.createDoubleSequenceBlock(10, 20), (Object)BlockAssertions.createDoubleSequenceBlock(20, 30), (Object)BlockAssertions.createDoubleSequenceBlock(15, 25));
        ImmutableList booleanChannel = ImmutableList.of((Object)BlockAssertions.createBooleanSequenceBlock(10, 20), (Object)BlockAssertions.createBooleanSequenceBlock(20, 30), (Object)BlockAssertions.createBooleanSequenceBlock(15, 25));
        ImmutableList extraUnusedChannel = ImmutableList.of((Object)BlockAssertions.createBooleanSequenceBlock(10, 20), (Object)BlockAssertions.createBooleanSequenceBlock(20, 30), (Object)BlockAssertions.createBooleanSequenceBlock(15, 25));
        OptionalInt hashChannel = OptionalInt.empty();
        ImmutableList channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel, (Object)extraUnusedChannel);
        ImmutableList precomputedHash = ImmutableList.of();
        if (hashEnabled) {
            ImmutableList.Builder hashChannelBuilder = ImmutableList.builder();
            for (int i = 0; i < 3; ++i) {
                hashChannelBuilder.add((Object)TypeUtils.getHashBlock((List)joinTypes, (Block[])new Block[]{(Block)varcharChannel.get(i), (Block)longChannel.get(i), (Block)doubleChannel.get(i), (Block)booleanChannel.get(i)}));
            }
            hashChannel = OptionalInt.of(6);
            precomputedHash = hashChannelBuilder.build();
            channels = ImmutableList.of((Object)extraChannel, (Object)varcharChannel, (Object)longChannel, (Object)doubleChannel, (Object)booleanChannel, (Object)extraUnusedChannel, (Object)precomputedHash);
            types = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
            outputTypes = ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT);
            outputChannels = Ints.asList((int[])new int[]{1, 2, 3, 4, 0, 6});
        }
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory((List)types, joinChannels, Optional.of(outputChannels));
        PagesHashStrategy hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy((List)channels, hashChannel);
        SimplePagesHashStrategy expectedHashStrategy = new SimplePagesHashStrategy((List)types, outputChannels, (List)channels, joinChannels, hashChannel, Optional.empty(), functionRegistry);
        Assert.assertEquals((int)hashStrategy.getChannelCount(), (int)outputChannels.size());
        int instanceSize = ClassLayout.parseClass(hashStrategy.getClass()).instanceSize();
        long sizeInBytes = (long)instanceSize + channels.stream().flatMap(Collection::stream).mapToLong(Block::getRetainedSizeInBytes).sum();
        Assert.assertEquals((long)hashStrategy.getSizeInBytes(), (long)sizeInBytes);
        for (int leftBlockIndex = 0; leftBlockIndex < varcharChannel.size(); ++leftBlockIndex) {
            PageBuilder pageBuilder = new PageBuilder((List)outputTypes);
            Block[] leftBlocks = new Block[]{(Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex)};
            int leftPositionCount = ((Block)varcharChannel.get(leftBlockIndex)).getPositionCount();
            for (int leftBlockPosition = 0; leftBlockPosition < leftPositionCount; ++leftBlockPosition) {
                int rightBlockIndex;
                Assert.assertEquals((long)hashStrategy.hashPosition(leftBlockIndex, leftBlockPosition), (long)expectedHashStrategy.hashPosition(leftBlockIndex, leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                Assert.assertTrue((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, leftBlockIndex, leftBlockPosition));
                for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                    Block rightBlock = (Block)varcharChannel.get(rightBlockIndex);
                    for (int rightBlockPosition = 0; rightBlockPosition < rightBlock.getPositionCount(); ++rightBlockPosition) {
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionEqualsPositionIgnoreNulls(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition), (boolean)expectedHashStrategy.positionEqualsPosition(leftBlockIndex, leftBlockPosition, rightBlockIndex, rightBlockPosition));
                    }
                }
                for (rightBlockIndex = 0; rightBlockIndex < varcharChannel.size(); ++rightBlockIndex) {
                    Block[] rightBlocks = new Block[]{(Block)varcharChannel.get(rightBlockIndex), (Block)longChannel.get(rightBlockIndex), (Block)doubleChannel.get(rightBlockIndex), (Block)booleanChannel.get(rightBlockIndex)};
                    int rightPositionCount = ((Block)varcharChannel.get(rightBlockIndex)).getPositionCount();
                    for (int rightPosition = 0; rightPosition < rightPositionCount; ++rightPosition) {
                        boolean expected = expectedHashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks));
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRow(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks)), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.rowEqualsRow(leftBlockPosition, new Page(leftBlocks), rightPosition, new Page(rightBlocks)), (boolean)expected);
                        Assert.assertEquals((boolean)hashStrategy.positionEqualsRowIgnoreNulls(leftBlockIndex, leftBlockPosition, rightPosition, new Page(rightBlocks)), (boolean)expected);
                    }
                }
                pageBuilder.declarePosition();
                hashStrategy.appendTo(leftBlockIndex, leftBlockPosition, pageBuilder, 0);
            }
            Page page = pageBuilder.build();
            if (hashEnabled) {
                PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, page, new Page(new Block[]{(Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex), (Block)extraChannel.get(leftBlockIndex), (Block)precomputedHash.get(leftBlockIndex)}));
                continue;
            }
            PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, page, new Page(new Block[]{(Block)varcharChannel.get(leftBlockIndex), (Block)longChannel.get(leftBlockIndex), (Block)doubleChannel.get(leftBlockIndex), (Block)booleanChannel.get(leftBlockIndex), (Block)extraChannel.get(leftBlockIndex)}));
        }
    }
}

