/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.UnaliasSymbolReferences;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestCanonicalize
extends BasePlanTest {
    @Test
    public void testJoin() {
        this.assertPlan("SELECT *\nFROM (\n    SELECT EXTRACT(DAY FROM DATE '2017-01-01')\n) t\nCROSS JOIN (VALUES 1)", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"X", (Object)PlanMatchPattern.expression("BIGINT '1'")), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of())), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of()))));
    }

    @Test
    public void testDuplicatesInWindowOrderBy() {
        ExpectedValueProvider<WindowNode.Specification> specification = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"A"), (Map<String, SortOrder>)ImmutableMap.of((Object)"A", (Object)SortOrder.ASC_NULLS_LAST));
        this.assertPlan("WITH x as (SELECT a, a as b FROM (VALUES 1) t(a))SELECT *, row_number() OVER(ORDER BY a ASC, b DESC)FROM x", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specification).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.values("A"))), (List<PlanOptimizer>)ImmutableList.of((Object)new UnaliasSymbolReferences(), (Object)new IterativeOptimizer(new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections()))));
    }
}

