/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.HyperLogLogType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.Literal;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.type.ColorType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDomainTranslator {
    private static final Symbol C_BIGINT = new Symbol("c_bigint");
    private static final Symbol C_DOUBLE = new Symbol("c_double");
    private static final Symbol C_VARCHAR = new Symbol("c_varchar");
    private static final Symbol C_BOOLEAN = new Symbol("c_boolean");
    private static final Symbol C_BIGINT_1 = new Symbol("c_bigint_1");
    private static final Symbol C_DOUBLE_1 = new Symbol("c_double_1");
    private static final Symbol C_VARCHAR_1 = new Symbol("c_varchar_1");
    private static final Symbol C_TIMESTAMP = new Symbol("c_timestamp");
    private static final Symbol C_DATE = new Symbol("c_date");
    private static final Symbol C_COLOR = new Symbol("c_color");
    private static final Symbol C_HYPER_LOG_LOG = new Symbol("c_hyper_log_log");
    private static final Symbol C_VARBINARY = new Symbol("c_varbinary");
    private static final Symbol C_DECIMAL_26_5 = new Symbol("c_decimal_26_5");
    private static final Symbol C_DECIMAL_23_4 = new Symbol("c_decimal_23_4");
    private static final Symbol C_INTEGER = new Symbol("c_integer");
    private static final Symbol C_CHAR = new Symbol("c_char");
    private static final Symbol C_DECIMAL_21_3 = new Symbol("c_decimal_21_3");
    private static final Symbol C_DECIMAL_12_2 = new Symbol("c_decimal_12_2");
    private static final Symbol C_DECIMAL_6_1 = new Symbol("c_decimal_6_1");
    private static final Symbol C_DECIMAL_3_0 = new Symbol("c_decimal_3_0");
    private static final Symbol C_DECIMAL_2_0 = new Symbol("c_decimal_2_0");
    private static final Symbol C_SMALLINT = new Symbol("c_smallint");
    private static final Symbol C_TINYINT = new Symbol("c_tinyint");
    private static final Symbol C_REAL = new Symbol("c_real");
    private static final TypeProvider TYPES = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)BigintType.BIGINT).put((Object)C_DOUBLE, (Object)DoubleType.DOUBLE).put((Object)C_VARCHAR, (Object)VarcharType.VARCHAR).put((Object)C_BOOLEAN, (Object)BooleanType.BOOLEAN).put((Object)C_BIGINT_1, (Object)BigintType.BIGINT).put((Object)C_DOUBLE_1, (Object)DoubleType.DOUBLE).put((Object)C_VARCHAR_1, (Object)VarcharType.VARCHAR).put((Object)C_TIMESTAMP, (Object)TimestampType.TIMESTAMP).put((Object)C_DATE, (Object)DateType.DATE).put((Object)C_COLOR, (Object)ColorType.COLOR).put((Object)C_HYPER_LOG_LOG, (Object)HyperLogLogType.HYPER_LOG_LOG).put((Object)C_VARBINARY, (Object)VarbinaryType.VARBINARY).put((Object)C_DECIMAL_26_5, (Object)DecimalType.createDecimalType((int)26, (int)5)).put((Object)C_DECIMAL_23_4, (Object)DecimalType.createDecimalType((int)23, (int)4)).put((Object)C_INTEGER, (Object)IntegerType.INTEGER).put((Object)C_CHAR, (Object)CharType.createCharType((long)10L)).put((Object)C_DECIMAL_21_3, (Object)DecimalType.createDecimalType((int)21, (int)3)).put((Object)C_DECIMAL_12_2, (Object)DecimalType.createDecimalType((int)12, (int)2)).put((Object)C_DECIMAL_6_1, (Object)DecimalType.createDecimalType((int)6, (int)1)).put((Object)C_DECIMAL_3_0, (Object)DecimalType.createDecimalType((int)3, (int)0)).put((Object)C_DECIMAL_2_0, (Object)DecimalType.createDecimalType((int)2, (int)0)).put((Object)C_SMALLINT, (Object)SmallintType.SMALLINT).put((Object)C_TINYINT, (Object)TinyintType.TINYINT).put((Object)C_REAL, (Object)RealType.REAL).build());
    private static final long TIMESTAMP_VALUE = new DateTime(2013, 3, 30, 1, 5, 0, 0, DateTimeZone.UTC).getMillis();
    private static final long DATE_VALUE = TimeUnit.MILLISECONDS.toDays(new DateTime(2001, 1, 22, 0, 0, 0, 0, DateTimeZone.UTC).getMillis());
    private static final long COLOR_VALUE_1 = 1L;
    private static final long COLOR_VALUE_2 = 2L;
    private Metadata metadata;
    private LiteralEncoder literalEncoder;
    private DomainTranslator domainTranslator;

    @BeforeClass
    public void setup() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.literalEncoder = new LiteralEncoder(this.metadata.getBlockEncodingSerde());
        this.domainTranslator = new DomainTranslator(this.literalEncoder);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.metadata = null;
        this.literalEncoder = null;
        this.domainTranslator = null;
    }

    @Test
    public void testNoneRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.none();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testAllRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.all();
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)tupleDomain);
    }

    @Test
    public void testRoundTrip() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true)).put((Object)C_BIGINT_1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)).put((Object)C_DOUBLE_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)1.1), (Range[])new Range[]{Range.equal((Type)DoubleType.DOUBLE, (Object)2.0), Range.range((Type)DoubleType.DOUBLE, (Object)3.0, (boolean)false, (Object)3.5, (boolean)true)}), (boolean)true)).put((Object)C_VARCHAR_1, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-01-01")), (Range[])new Range[]{Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"2013-10-01"))}), (boolean)false)).put((Object)C_TIMESTAMP, (Object)Domain.singleValue((Type)TimestampType.TIMESTAMP, (Object)TIMESTAMP_VALUE)).put((Object)C_DATE, (Object)Domain.singleValue((Type)DateType.DATE, (Object)DATE_VALUE)).put((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L)).put((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)).build());
        this.assertPredicateTranslates(this.toPredicate((TupleDomain<Symbol>)tupleDomain), (TupleDomain<Symbol>)tupleDomain);
    }

    @Test
    public void testInOptimization() {
        Domain testDomain = Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)})), (boolean)false);
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)3L, (boolean)true), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)5L, (boolean)true, (Object)7L, (boolean)true), Range.range((Type)BigintType.BIGINT, (Object)9L, (boolean)true, (Object)11L, (boolean)true)}), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(3L)), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L), (Expression)TestDomainTranslator.bigintLiteral(7L)), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(9L), (Expression)TestDomainTranslator.bigintLiteral(11L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)true, (Object)9L, (boolean)true), (Range[])new Range[0])), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(7L), (Expression)TestDomainTranslator.bigintLiteral(9L))}));
        testDomain = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)4L), (Range[])new Range[0]).intersect(ValueSet.all((Type)BigintType.BIGINT).subtract(ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L), Range.equal((Type)BigintType.BIGINT, (Object)3L)}))).union(ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)7L, (boolean)false, (Object)9L, (boolean)false), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)11L, (boolean)false, (Object)13L, (boolean)false)})), (boolean)false);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)testDomain).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(4L)), TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(7L)), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(9L))}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(11L)), TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(13L))})}));
    }

    @Test
    public void testToPredicateNone() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.none((Type)BooleanType.BOOLEAN)).build());
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testToPredicateAllIgnored() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).put((Object)C_BOOLEAN, (Object)Domain.all((Type)BooleanType.BOOLEAN)).build());
        DomainTranslator.ExtractionResult result = this.fromPredicate(this.toPredicate((TupleDomain<Symbol>)tupleDomain));
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.builder().put((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)).put((Object)C_DOUBLE, (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)).put((Object)C_VARCHAR, (Object)Domain.notNull((Type)VarcharType.VARCHAR)).build()));
    }

    @Test
    public void testToPredicate() {
        TupleDomain tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.isNotNull(C_BIGINT));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.isNull(C_BIGINT));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.none((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)BooleanLiteral.FALSE_LITERAL);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.all((Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)BooleanLiteral.TRUE_LITERAL);
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)false, (Object)1L, (boolean)true), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(0L)), TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L)));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.isNull(C_BIGINT)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.equal(C_COLOR, (Expression)TestDomainTranslator.colorLiteral(1L)), TestDomainTranslator.isNull(C_COLOR)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, (Expression)TestDomainTranslator.colorLiteral(1L))), TestDomainTranslator.isNull(C_COLOR)}));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.isNull(C_HYPER_LOG_LOG));
        tupleDomain = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG)));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)tupleDomain), (Object)TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG));
    }

    @Test
    public void testFromUnknownPredicate() {
        this.assertUnsupportedPredicate(TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(C_BIGINT)));
    }

    @Test
    public void testFromAndPredicate() {
        Expression originalPredicate = ExpressionUtils.and((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})})));
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testFromOrPredicate() {
        Expression originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        DomainTranslator.ExtractionResult result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertUnsupportedPredicate(ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})}));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(1.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.greaterThan(C_DOUBLE, (Expression)TestDomainTranslator.doubleLiteral(2.0)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)TestDomainTranslator.unprocessableExpression1(C_BIGINT));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false), (Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)1.0), (Range[])new Range[0]), (boolean)false))));
        originalPredicate = ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), TestDomainTranslator.randPredicate(C_BIGINT, (Type)BigintType.BIGINT)})});
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)originalPredicate);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.or((Expression[])new Expression[]{ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)}), ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)})}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        Assert.assertTrue((boolean)result.getTupleDomain().isAll());
        originalPredicate = TestDomainTranslator.not(ExpressionUtils.or((Expression[])new Expression[]{TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})), TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(5L)), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}))}));
        result = this.fromPredicate(originalPredicate);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)}));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)5L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromNotPredicate() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L)), TestDomainTranslator.unprocessableExpression1(C_BIGINT)})));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not(TestDomainTranslator.unprocessableExpression1(C_BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)1L)}), (boolean)false))));
    }

    @Test
    public void testFromUnprocessableComparison() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestDomainTranslator.unprocessableExpression1(C_BIGINT), TestDomainTranslator.unprocessableExpression2(C_BIGINT))));
    }

    @Test
    public void testFromBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(C_COLOR, (Expression)TestDomainTranslator.colorLiteral(1L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestDomainTranslator.colorLiteral(1L), (Object)TestDomainTranslator.colorLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, (Expression)TestDomainTranslator.colorLiteral(1L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, (Expression)TestDomainTranslator.colorLiteral(1L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestDomainTranslator.colorLiteral(1L), (Object)TestDomainTranslator.colorLiteral(2L)))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, (Expression)TestDomainTranslator.colorLiteral(1L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
    }

    @Test
    public void testFromFlippedBasicComparisons() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, (Expression)TestDomainTranslator.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, (Expression)TestDomainTranslator.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.bigintLiteral(2L), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)TestDomainTranslator.colorLiteral(1L), (Expression)C_COLOR.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[0]).complement(), (boolean)true))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT), (Expression)C_BIGINT.toSymbolReference()), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testFromBasicComparisonsWithNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.nullLiteral((Type)VarcharType.VARCHAR)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.none((Type)VarcharType.VARCHAR), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.equal(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.notEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.notEqual(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.notNull((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_BIGINT, TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(C_COLOR, TestDomainTranslator.nullLiteral((Type)ColorType.COLOR))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.onlyNull((Type)ColorType.COLOR))));
    }

    @Test
    void testNonImplictCastOnSymbolSide() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal((Expression)new Cast((Expression)C_TIMESTAMP.toSymbolReference(), DateType.DATE.toString()), this.toExpression(DATE_VALUE, (Type)DateType.DATE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal((Expression)new Cast((Expression)C_DECIMAL_12_2.toSymbolReference(), BigintType.BIGINT.toString()), (Expression)TestDomainTranslator.bigintLiteral(135L)));
    }

    @Test
    void testNoSaturatedFloorCastFromUnsupportedApproximateDomain() {
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal((Expression)new Cast((Expression)C_DECIMAL_12_2.toSymbolReference(), DoubleType.DOUBLE.toString()), this.toExpression(12345.56, (Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal((Expression)new Cast((Expression)C_BIGINT.toSymbolReference(), DoubleType.DOUBLE.toString()), this.toExpression(12345.56, (Type)DoubleType.DOUBLE)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal((Expression)new Cast((Expression)C_BIGINT.toSymbolReference(), RealType.REAL.toString()), this.toExpression(TestDomainTranslator.realValue(12345.56f), (Type)RealType.REAL)));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal((Expression)new Cast((Expression)C_INTEGER.toSymbolReference(), RealType.REAL.toString()), this.toExpression(TestDomainTranslator.realValue(12345.56f), (Type)RealType.REAL)));
    }

    @Test
    public void testFromComparisonsWithCoercions() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(2L), (Type)DoubleType.DOUBLE)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.stringLiteral("test", (Type)VarcharType.VARCHAR)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.none((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.notNull((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)true))));
        this.assertPredicateIsAlwaysTrue((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_DOUBLE, TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(2L), (Type)DoubleType.DOUBLE))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)DoubleType.DOUBLE, (Object)2.0), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(C_VARCHAR, TestDomainTranslator.stringLiteral("test", (Type)VarcharType.VARCHAR))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARCHAR, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)"test")), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.greaterThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThan(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.lessThanOrEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.notNull((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.notEqual(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.none((Type)IntegerType.INTEGER))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.0))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)IntegerType.INTEGER, (Object)2L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isDistinctFrom(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))));
    }

    @Test
    public void testFromUnprocessableInPredicate() {
        this.assertUnsupportedPredicate((Expression)new InPredicate(TestDomainTranslator.unprocessableExpression1(C_BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL))));
        this.assertUnsupportedPredicate((Expression)new InPredicate((Expression)C_BOOLEAN.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN)))));
        this.assertUnsupportedPredicate((Expression)new InPredicate((Expression)C_BOOLEAN.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN)))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)new InPredicate((Expression)C_BOOLEAN.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.unprocessableExpression1(C_BOOLEAN))))));
    }

    @Test
    public void testFromInPredicate() {
        this.assertPredicateTranslates((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestDomainTranslator.colorLiteral(1L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.singleValue((Type)ColorType.COLOR, (Object)1L))));
        this.assertPredicateTranslates((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestDomainTranslator.colorLiteral(1L), (Object)TestDomainTranslator.colorLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_BIGINT, (List<?>)ImmutableList.of((Object)1L, (Object)2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)2L, (boolean)false), Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)this.in(C_COLOR, (List<?>)ImmutableList.of((Object)TestDomainTranslator.colorLiteral(1L), (Object)TestDomainTranslator.colorLiteral(2L)))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_COLOR, (Object)Domain.create((ValueSet)ValueSet.of((Type)ColorType.COLOR, (Object)1L, (Object[])new Object[]{2L}).complement(), (boolean)false))));
    }

    @Test
    public void testInPredicateWithNull() {
        this.assertPredicateTranslates((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.equal((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null))));
        this.assertPredicateIsAlwaysFalse((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null})));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null}))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.isNull((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null))));
        this.assertUnsupportedPredicate(TestDomainTranslator.isNotNull((Expression)this.in(C_BIGINT, Arrays.asList(1L, 2L, null))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.isNull((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null}))));
        this.assertUnsupportedPredicate(TestDomainTranslator.isNotNull((Expression)this.in(C_BIGINT, Arrays.asList(new Long[]{null}))));
    }

    @Test
    public void testInPredicateWithCasts() {
        this.assertPredicateTranslates((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(1L, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT)))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        this.assertPredicateTranslates((Expression)new InPredicate(TestDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)this.toExpression(1L, (Type)BigintType.BIGINT)))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_SMALLINT, (Object)Domain.singleValue((Type)SmallintType.SMALLINT, (Object)1L))));
        this.assertUnsupportedPredicate((Expression)new InPredicate(TestDomainTranslator.cast(C_BIGINT, (Type)IntegerType.INTEGER), (Expression)new InListExpression((List)ImmutableList.of((Object)this.toExpression(1L, (Type)IntegerType.INTEGER)))));
    }

    @Test
    public void testFromInPredicateWithCastsAndNulls() {
        this.assertPredicateIsAlwaysFalse((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT)))));
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.not((Expression)new InPredicate(TestDomainTranslator.cast(C_SMALLINT, (Type)BigintType.BIGINT), (Expression)new InListExpression((List)ImmutableList.of((Object)this.toExpression(null, (Type)BigintType.BIGINT))))));
        this.assertPredicateTranslates((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)this.toExpression(1L, (Type)BigintType.BIGINT)))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.equal((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)new InPredicate((Expression)C_BIGINT.toSymbolReference(), (Expression)new InListExpression((List)ImmutableList.of((Object)TestDomainTranslator.cast(this.toExpression(null, (Type)SmallintType.SMALLINT), (Type)BigintType.BIGINT), (Object)this.toExpression(1L, (Type)SmallintType.SMALLINT))))));
    }

    @Test
    public void testFromBetweenPredicate() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(2L)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.between(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(1L), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)1L, (boolean)true, (Object)2L, (boolean)true), (Range[])new Range[0]), (boolean)false))));
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT)));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), (Expression)TestDomainTranslator.bigintLiteral(2L))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)BigintType.BIGINT, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(TestDomainTranslator.cast(C_INTEGER, (Type)DoubleType.DOUBLE), TestDomainTranslator.cast((Expression)TestDomainTranslator.bigintLiteral(1L), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(2.1))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_INTEGER, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)IntegerType.INTEGER, (Object)1L), (Range[])new Range[]{Range.greaterThan((Type)IntegerType.INTEGER, (Object)2L)}), (boolean)false))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.between(C_BIGINT, (Expression)TestDomainTranslator.bigintLiteral(1L), TestDomainTranslator.nullLiteral((Type)BigintType.BIGINT))), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)BigintType.BIGINT, (Object)1L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testFromIsNullPredicate() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isNull(C_BIGINT), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.isNull(C_HYPER_LOG_LOG), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(C_BIGINT)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.isNull(C_HYPER_LOG_LOG)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
    }

    @Test
    public void testFromIsNotNullPredicate() {
        this.assertPredicateTranslates(TestDomainTranslator.isNotNull(C_BIGINT), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.notNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates(TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.notNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not(TestDomainTranslator.isNotNull(C_BIGINT)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
        this.assertPredicateTranslates((Expression)TestDomainTranslator.not(TestDomainTranslator.isNotNull(C_HYPER_LOG_LOG)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_HYPER_LOG_LOG, (Object)Domain.onlyNull((Type)HyperLogLogType.HYPER_LOG_LOG))));
    }

    @Test
    public void testFromBooleanLiteralPredicate() {
        this.assertPredicateIsAlwaysTrue((Expression)BooleanLiteral.TRUE_LITERAL);
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)BooleanLiteral.TRUE_LITERAL));
        this.assertPredicateIsAlwaysFalse((Expression)BooleanLiteral.FALSE_LITERAL);
        this.assertPredicateIsAlwaysTrue((Expression)TestDomainTranslator.not((Expression)BooleanLiteral.FALSE_LITERAL));
    }

    @Test
    public void testFromNullLiteralPredicate() {
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.nullLiteral());
        this.assertPredicateIsAlwaysFalse((Expression)TestDomainTranslator.not((Expression)TestDomainTranslator.nullLiteral()));
    }

    @Test
    public void testExpressionConstantFolding() {
        ComparisonExpression originalExpression = TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_VARBINARY.toSymbolReference(), (Expression)TestDomainTranslator.function("from_hex", new Expression[]{TestDomainTranslator.stringLiteral("123456")}));
        DomainTranslator.ExtractionResult result = this.fromPredicate((Expression)originalExpression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Slice value = Slices.wrappedBuffer((byte[])BaseEncoding.base16().decode((CharSequence)"123456"));
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_VARBINARY, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)VarbinaryType.VARBINARY, (Object)value), (Range[])new Range[0]), (boolean)false))));
        Expression expression = this.toPredicate((TupleDomain<Symbol>)result.getTupleDomain());
        Assert.assertEquals((Object)expression, (Object)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_VARBINARY.toSymbolReference(), this.varbinaryLiteral(value)));
    }

    @Test
    public void testConjunctExpression() {
        Expression expression = ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_DOUBLE.toSymbolReference(), (Expression)TestDomainTranslator.doubleLiteral(0.0)), TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_BIGINT.toSymbolReference(), (Expression)TestDomainTranslator.bigintLiteral(0L))});
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_BIGINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)BigintType.BIGINT, (Object)0L), (Range[])new Range[0]), (boolean)false), (Object)C_DOUBLE, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[0]), (boolean)false))));
        Assert.assertEquals((Object)this.toPredicate((TupleDomain<Symbol>)this.fromPredicate(expression).getTupleDomain()), (Object)ExpressionUtils.and((Expression[])new Expression[]{TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_BIGINT.toSymbolReference(), (Expression)TestDomainTranslator.bigintLiteral(0L)), TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)C_DOUBLE.toSymbolReference(), (Expression)TestDomainTranslator.doubleLiteral(0.0))}));
    }

    @Test
    void testMultipleCoercionsOnSymbolSide() {
        this.assertPredicateTranslates((Expression)TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, TestDomainTranslator.cast(TestDomainTranslator.cast(C_SMALLINT, (Type)RealType.REAL), (Type)DoubleType.DOUBLE), (Expression)TestDomainTranslator.doubleLiteral(3.7)), (TupleDomain<Symbol>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)C_SMALLINT, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThan((Type)SmallintType.SMALLINT, (Object)3L), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testNumericTypeTranslation() {
        this.testNumericTypeTranslationChain(new NumericValues(C_DECIMAL_26_5, TestDomainTranslator.longDecimal("-999999999999999999999.99999"), TestDomainTranslator.longDecimal("-22.00000"), TestDomainTranslator.longDecimal("-44.55569"), TestDomainTranslator.longDecimal("23.00000"), TestDomainTranslator.longDecimal("44.55567"), TestDomainTranslator.longDecimal("999999999999999999999.99999")), new NumericValues(C_DECIMAL_23_4, TestDomainTranslator.longDecimal("-9999999999999999999.9999"), TestDomainTranslator.longDecimal("-22.0000"), TestDomainTranslator.longDecimal("-44.5557"), TestDomainTranslator.longDecimal("23.0000"), TestDomainTranslator.longDecimal("44.5556"), TestDomainTranslator.longDecimal("9999999999999999999.9999")), new NumericValues(C_BIGINT, Long.MIN_VALUE, -22L, -45L, 23L, 44L, Long.MAX_VALUE), new NumericValues(C_DECIMAL_21_3, TestDomainTranslator.longDecimal("-999999999999999999.999"), TestDomainTranslator.longDecimal("-22.000"), TestDomainTranslator.longDecimal("-44.556"), TestDomainTranslator.longDecimal("23.000"), TestDomainTranslator.longDecimal("44.555"), TestDomainTranslator.longDecimal("999999999999999999.999")), new NumericValues(C_DECIMAL_12_2, TestDomainTranslator.shortDecimal("-9999999999.99"), TestDomainTranslator.shortDecimal("-22.00"), TestDomainTranslator.shortDecimal("-44.56"), TestDomainTranslator.shortDecimal("23.00"), TestDomainTranslator.shortDecimal("44.55"), TestDomainTranslator.shortDecimal("9999999999.99")), new NumericValues(C_INTEGER, Integer.MIN_VALUE, -22L, -45L, 23L, 44L, Integer.MAX_VALUE), new NumericValues(C_DECIMAL_6_1, TestDomainTranslator.shortDecimal("-99999.9"), TestDomainTranslator.shortDecimal("-22.0"), TestDomainTranslator.shortDecimal("-44.6"), TestDomainTranslator.shortDecimal("23.0"), TestDomainTranslator.shortDecimal("44.5"), TestDomainTranslator.shortDecimal("99999.9")), new NumericValues(C_SMALLINT, -32768L, -22L, -45L, 23L, 44L, 32767L), new NumericValues(C_DECIMAL_3_0, TestDomainTranslator.shortDecimal("-999"), TestDomainTranslator.shortDecimal("-22"), TestDomainTranslator.shortDecimal("-45"), TestDomainTranslator.shortDecimal("23"), TestDomainTranslator.shortDecimal("44"), TestDomainTranslator.shortDecimal("999")), new NumericValues(C_TINYINT, -128L, -22L, -45L, 23L, 44L, 127L), new NumericValues(C_DECIMAL_2_0, TestDomainTranslator.shortDecimal("-99"), TestDomainTranslator.shortDecimal("-22"), TestDomainTranslator.shortDecimal("-45"), TestDomainTranslator.shortDecimal("23"), TestDomainTranslator.shortDecimal("44"), TestDomainTranslator.shortDecimal("99")));
        this.testNumericTypeTranslationChain(new NumericValues(C_DOUBLE, -1.7976931348623157E308, -22.0, -44.5556836, 23.0, 44.5556789, Double.MAX_VALUE), new NumericValues(C_REAL, TestDomainTranslator.realValue(-3.4028235E38f), TestDomainTranslator.realValue(-22.0f), TestDomainTranslator.realValue(-44.555687f), TestDomainTranslator.realValue(23.0f), TestDomainTranslator.realValue(44.555676f), TestDomainTranslator.realValue(Float.MAX_VALUE)));
    }

    private void testNumericTypeTranslationChain(NumericValues ... translationChain) {
        for (int literalIndex = 0; literalIndex < translationChain.length; ++literalIndex) {
            for (int columnIndex = literalIndex + 1; columnIndex < translationChain.length; ++columnIndex) {
                NumericValues literal = translationChain[literalIndex];
                NumericValues column = translationChain[columnIndex];
                this.testNumericTypeTranslation(column, literal);
            }
        }
    }

    private void testNumericTypeTranslation(NumericValues columnValues, NumericValues literalValues) {
        Type columnType = columnValues.getType();
        Type literalType = literalValues.getType();
        Type superType = (Type)this.metadata.getTypeManager().getCommonSuperType(columnType, literalType).orElseThrow(() -> new IllegalArgumentException("incompatible types in test (" + columnType + ", " + literalType + ")"));
        Expression max = this.toExpression(literalValues.getMax(), literalType);
        Expression min = this.toExpression(literalValues.getMin(), literalType);
        Expression integerPositive = this.toExpression(literalValues.getIntegerPositive(), literalType);
        Expression integerNegative = this.toExpression(literalValues.getIntegerNegative(), literalType);
        Expression fractionalPositive = this.toExpression(literalValues.getFractionalPositive(), literalType);
        Expression fractionalNegative = this.toExpression(literalValues.getFractionalNegative(), literalType);
        if (!literalType.equals(superType)) {
            max = TestDomainTranslator.cast(max, superType);
            min = TestDomainTranslator.cast(min, superType);
            integerPositive = TestDomainTranslator.cast(integerPositive, superType);
            integerNegative = TestDomainTranslator.cast(integerNegative, superType);
            fractionalPositive = TestDomainTranslator.cast(fractionalPositive, superType);
            fractionalNegative = TestDomainTranslator.cast(fractionalNegative, superType);
        }
        Symbol columnSymbol = columnValues.getColumn();
        SymbolReference columnExpression = columnSymbol.toSymbolReference();
        if (!columnType.equals(superType)) {
            columnExpression = TestDomainTranslator.cast((Expression)columnExpression, superType);
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerPositive), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, integerNegative), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, max), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, min), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThanOrEqual((Expression)columnExpression, fractionalNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, integerNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, max), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, min), columnSymbol, Range.greaterThanOrEqual((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalPositive), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.greaterThan((Expression)columnExpression, fractionalNegative), columnSymbol, Range.greaterThan((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, integerNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, max), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, min), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThanOrEqual((Expression)columnExpression, fractionalNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerPositive), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, integerNegative), columnSymbol, Range.lessThan((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, max), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getMax()));
        this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, min), columnSymbol, Range.lessThan((Type)columnType, columnValues.getMin()));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalPositive), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalPositive()));
            this.testSimpleComparison((Expression)TestDomainTranslator.lessThan((Expression)columnExpression, fractionalNegative), columnSymbol, Range.lessThanOrEqual((Type)columnType, columnValues.getFractionalNegative()));
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerPositive), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerPositive()));
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, integerNegative), columnSymbol, Range.equal((Type)columnType, columnValues.getIntegerNegative()));
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, max), columnSymbol, Domain.none((Type)columnType));
        this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, min), columnSymbol, Domain.none((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.none((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.equal((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.none((Type)columnType));
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerPositive), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)false));
        this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, integerNegative), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)false));
        this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, max), columnSymbol, Domain.notNull((Type)columnType));
        this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, min), columnSymbol, Domain.notNull((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.notNull((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.notEqual((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.notNull((Type)columnType));
        }
        this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerPositive), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerPositive()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerPositive())}), (boolean)true));
        this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, integerNegative), columnSymbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)columnType, columnValues.getIntegerNegative()), (Range[])new Range[]{Range.greaterThan((Type)columnType, columnValues.getIntegerNegative())}), (boolean)true));
        this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, max), columnSymbol, Domain.all((Type)columnType));
        this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, min), columnSymbol, Domain.all((Type)columnType));
        if (literalValues.isFractional()) {
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalPositive), columnSymbol, Domain.all((Type)columnType));
            this.testSimpleComparison((Expression)TestDomainTranslator.isDistinctFrom((Expression)columnExpression, fractionalNegative), columnSymbol, Domain.all((Type)columnType));
        }
    }

    @Test
    public void testCharComparedToVarcharExpression() {
        CharType charType = CharType.createCharType((long)10L);
        this.testSimpleComparison((Expression)TestDomainTranslator.equal(C_CHAR, TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral("abc"), (Type)charType)), C_CHAR, Range.equal((Type)charType, (Object)Slices.utf8Slice((String)"abc")));
        charType = CharType.createCharType((long)11L);
        this.assertUnsupportedPredicate((Expression)TestDomainTranslator.equal(TestDomainTranslator.cast(C_CHAR, (Type)charType), TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral("abc12345678"), (Type)charType)));
    }

    private void assertPredicateIsAlwaysTrue(Expression expression) {
        this.assertPredicateTranslates(expression, (TupleDomain<Symbol>)TupleDomain.all());
    }

    private void assertPredicateIsAlwaysFalse(Expression expression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertTrue((boolean)result.getTupleDomain().isNone());
    }

    private void assertUnsupportedPredicate(Expression expression) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)expression);
        Assert.assertEquals((Object)result.getTupleDomain(), (Object)TupleDomain.all());
    }

    private void assertPredicateTranslates(Expression expression, TupleDomain<Symbol> tupleDomain) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        Assert.assertEquals((Object)result.getTupleDomain(), tupleDomain);
    }

    private DomainTranslator.ExtractionResult fromPredicate(Expression originalPredicate) {
        return DomainTranslator.fromPredicate((Metadata)this.metadata, (Session)SessionTestUtils.TEST_SESSION, (Expression)originalPredicate, (TypeProvider)TYPES);
    }

    private Expression toPredicate(TupleDomain<Symbol> tupleDomain) {
        return this.domainTranslator.toPredicate(tupleDomain);
    }

    private static Expression unprocessableExpression1(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)symbol.toSymbolReference(), (Expression)symbol.toSymbolReference());
    }

    private static Expression unprocessableExpression2(Symbol symbol) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, (Expression)symbol.toSymbolReference(), (Expression)symbol.toSymbolReference());
    }

    private static Expression randPredicate(Symbol symbol, Type type) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, (Expression)symbol.toSymbolReference(), TestDomainTranslator.cast((Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of()), type));
    }

    private static ComparisonExpression equal(Symbol symbol, Expression expression) {
        return TestDomainTranslator.equal((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression notEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.notEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression greaterThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.greaterThan((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression greaterThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.greaterThanOrEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression lessThan(Symbol symbol, Expression expression) {
        return TestDomainTranslator.lessThan((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression lessThanOrEqual(Symbol symbol, Expression expression) {
        return TestDomainTranslator.lessThanOrEqual((Expression)symbol.toSymbolReference(), expression);
    }

    private static ComparisonExpression isDistinctFrom(Symbol symbol, Expression expression) {
        return TestDomainTranslator.isDistinctFrom((Expression)symbol.toSymbolReference(), expression);
    }

    private static Expression isNotNull(Symbol symbol) {
        return TestDomainTranslator.isNotNull((Expression)symbol.toSymbolReference());
    }

    private static IsNullPredicate isNull(Symbol symbol) {
        return new IsNullPredicate((Expression)symbol.toSymbolReference());
    }

    private InPredicate in(Symbol symbol, List<?> values) {
        return this.in((Expression)symbol.toSymbolReference(), TYPES.get(symbol), values);
    }

    private static BetweenPredicate between(Symbol symbol, Expression min, Expression max) {
        return new BetweenPredicate((Expression)symbol.toSymbolReference(), min, max);
    }

    private static Expression isNotNull(Expression expression) {
        return new NotExpression((Expression)new IsNullPredicate(expression));
    }

    private static IsNullPredicate isNull(Expression expression) {
        return new IsNullPredicate(expression);
    }

    private InPredicate in(Expression expression, Type expressisonType, List<?> values) {
        List<Type> types = Collections.nCopies(values.size(), expressisonType);
        List expressions = this.literalEncoder.toExpressions(values, types);
        return new InPredicate(expression, (Expression)new InListExpression(expressions));
    }

    private static BetweenPredicate between(Expression expression, Expression min, Expression max) {
        return new BetweenPredicate(expression, min, max);
    }

    private static ComparisonExpression equal(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.EQUAL, left, right);
    }

    private static ComparisonExpression notEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.NOT_EQUAL, left, right);
    }

    private static ComparisonExpression greaterThan(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN, left, right);
    }

    private static ComparisonExpression greaterThanOrEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, left, right);
    }

    private static ComparisonExpression lessThan(Expression left, Expression expression) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN, left, expression);
    }

    private static ComparisonExpression lessThanOrEqual(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, left, right);
    }

    private static ComparisonExpression isDistinctFrom(Expression left, Expression right) {
        return TestDomainTranslator.comparison(ComparisonExpression.Operator.IS_DISTINCT_FROM, left, right);
    }

    private static NotExpression not(Expression expression) {
        return new NotExpression(expression);
    }

    private static ComparisonExpression comparison(ComparisonExpression.Operator operator, Expression expression1, Expression expression2) {
        return new ComparisonExpression(operator, expression1, expression2);
    }

    private static Literal bigintLiteral(long value) {
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return new GenericLiteral("BIGINT", Long.toString(value));
        }
        return new LongLiteral(Long.toString(value));
    }

    private static DoubleLiteral doubleLiteral(double value) {
        return new DoubleLiteral(Double.toString(value));
    }

    private static StringLiteral stringLiteral(String value) {
        return new StringLiteral(value);
    }

    private static Expression stringLiteral(String value, Type type) {
        return TestDomainTranslator.cast((Expression)TestDomainTranslator.stringLiteral(value), type);
    }

    private static NullLiteral nullLiteral() {
        return new NullLiteral();
    }

    private static Expression nullLiteral(Type type) {
        return TestDomainTranslator.cast((Expression)new NullLiteral(), type);
    }

    private static Expression cast(Symbol symbol, Type type) {
        return TestDomainTranslator.cast((Expression)symbol.toSymbolReference(), type);
    }

    private static Expression cast(Expression expression, Type type) {
        return new Cast(expression, type.getTypeSignature().toString());
    }

    private static FunctionCall colorLiteral(long value) {
        return new FunctionCall(QualifiedName.of((String)FunctionRegistry.getMagicLiteralFunctionSignature((Type)ColorType.COLOR).getName()), (List)ImmutableList.of((Object)TestDomainTranslator.bigintLiteral(value)));
    }

    private Expression varbinaryLiteral(Slice value) {
        return this.toExpression(value, (Type)VarbinaryType.VARBINARY);
    }

    private static FunctionCall function(String functionName, Expression ... args) {
        return new FunctionCall(QualifiedName.of((String)functionName), (List)ImmutableList.copyOf((Object[])args));
    }

    private static Long shortDecimal(String value) {
        return new BigDecimal(value).unscaledValue().longValueExact();
    }

    private static Slice longDecimal(String value) {
        return Decimals.encodeScaledValue((BigDecimal)new BigDecimal(value));
    }

    private static Long realValue(float value) {
        return Float.floatToIntBits(value);
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Range expectedDomainRange) {
        this.testSimpleComparison(expression, symbol, Domain.create((ValueSet)ValueSet.ofRanges((Range)expectedDomainRange, (Range[])new Range[0]), (boolean)false));
    }

    private void testSimpleComparison(Expression expression, Symbol symbol, Domain domain) {
        DomainTranslator.ExtractionResult result = this.fromPredicate(expression);
        Assert.assertEquals((Object)result.getRemainingExpression(), (Object)BooleanLiteral.TRUE_LITERAL);
        TupleDomain actual = result.getTupleDomain();
        TupleDomain expected = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)symbol, (Object)domain));
        if (!actual.equals((Object)expected)) {
            Assert.fail((String)String.format("for comparison [%s] expected %s but found %s", expression.toString(), expected.toString(TestingConnectorSession.SESSION), actual.toString(TestingConnectorSession.SESSION)));
        }
    }

    private Expression toExpression(Object object, Type type) {
        return this.literalEncoder.toExpression(object, type);
    }

    private List<Expression> toExpressions(List<?> objects, List<? extends Type> types) {
        return this.literalEncoder.toExpressions(objects, types);
    }

    private static class NumericValues<T> {
        private final Symbol column;
        private final Type type;
        private final T min;
        private final T integerNegative;
        private final T fractionalNegative;
        private final T integerPositive;
        private final T fractionalPositive;
        private final T max;

        private NumericValues(Symbol column, T min, T integerNegative, T fractionalNegative, T integerPositive, T fractionalPositive, T max) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.type = Objects.requireNonNull(TYPES.get(column), "type for column not found: " + column);
            this.min = Objects.requireNonNull(min, "min is null");
            this.integerNegative = Objects.requireNonNull(integerNegative, "integerNegative is null");
            this.fractionalNegative = Objects.requireNonNull(fractionalNegative, "fractionalNegative is null");
            this.integerPositive = Objects.requireNonNull(integerPositive, "integerPositive is null");
            this.fractionalPositive = Objects.requireNonNull(fractionalPositive, "fractionalPositive is null");
            this.max = Objects.requireNonNull(max, "max is null");
        }

        public Symbol getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public T getMin() {
            return this.min;
        }

        public T getIntegerNegative() {
            return this.integerNegative;
        }

        public T getFractionalNegative() {
            return this.fractionalNegative;
        }

        public T getIntegerPositive() {
            return this.integerPositive;
        }

        public T getFractionalPositive() {
            return this.fractionalPositive;
        }

        public T getMax() {
            return this.max;
        }

        public boolean isFractional() {
            return this.type == DoubleType.DOUBLE || this.type == RealType.REAL || this.type instanceof DecimalType && ((DecimalType)this.type).getScale() > 0;
        }
    }
}

