/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import io.prestosql.Session;
import io.prestosql.block.BlockEncodingManager;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.AbstractMockMetadata;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableProperties;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.DomainTranslator;
import io.prestosql.sql.planner.EffectivePredicateExtractor;
import io.prestosql.sql.planner.EqualityInference;
import io.prestosql.sql.planner.ExpressionNodeInliner;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.SubExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TestingConnectorTransactionHandle;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.testing.TestingMetadata;
import io.prestosql.testing.TestingSession;
import io.prestosql.testing.TestingTransactionHandle;
import io.prestosql.type.TypeRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestEffectivePredicateExtractor {
    private static final Symbol A = new Symbol("a");
    private static final Symbol B = new Symbol("b");
    private static final Symbol C = new Symbol("c");
    private static final Symbol D = new Symbol("d");
    private static final Symbol E = new Symbol("e");
    private static final Symbol F = new Symbol("f");
    private static final Symbol G = new Symbol("g");
    private static final Expression AE = A.toSymbolReference();
    private static final Expression BE = B.toSymbolReference();
    private static final Expression CE = C.toSymbolReference();
    private static final Expression DE = D.toSymbolReference();
    private static final Expression EE = E.toSymbolReference();
    private static final Expression FE = F.toSymbolReference();
    private static final Expression GE = G.toSymbolReference();
    private static final Session SESSION = TestingSession.testSessionBuilder().build();
    private final Metadata metadata = new AbstractMockMetadata(){

        @Override
        public BlockEncodingSerde getBlockEncodingSerde() {
            return new BlockEncodingManager((TypeManager)new TypeRegistry((Set)ImmutableSet.of(), new FeaturesConfig()), new BlockEncoding[0]);
        }

        @Override
        public TableProperties getTableProperties(Session session, TableHandle handle) {
            return new TableProperties(new CatalogName("test"), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, new ConnectorTableProperties(((PredicatedTableHandle)handle.getConnectorHandle()).getPredicate(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        }
    };
    private final EffectivePredicateExtractor effectivePredicateExtractor = new EffectivePredicateExtractor(new DomainTranslator(new LiteralEncoder(this.metadata.getBlockEncodingSerde())), this.metadata);
    private Map<Symbol, ColumnHandle> scanAssignments;
    private TableScanNode baseTableScan;
    private ExpressionIdentityNormalizer expressionNormalizer;

    @BeforeMethod
    public void setUp() {
        this.scanAssignments = ImmutableMap.builder().put((Object)A, (Object)new TestingMetadata.TestingColumnHandle("a")).put((Object)B, (Object)new TestingMetadata.TestingColumnHandle("b")).put((Object)C, (Object)new TestingMetadata.TestingColumnHandle("c")).put((Object)D, (Object)new TestingMetadata.TestingColumnHandle("d")).put((Object)E, (Object)new TestingMetadata.TestingColumnHandle("e")).put((Object)F, (Object)new TestingMetadata.TestingColumnHandle("f")).build();
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D, (Object)E, (Object)F)));
        this.baseTableScan = TableScanNode.newInstance((PlanNodeId)TestEffectivePredicateExtractor.newId(), (TableHandle)TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments);
        this.expressionNormalizer = new ExpressionIdentityNormalizer();
    }

    @Test
    public void testAggregation() {
        AggregationNode node = new AggregationNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.equals(CE, FE), TestEffectivePredicateExtractor.lessThan(DE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(CE, DE), TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(2L)), TestEffectivePredicateExtractor.equals(EE, FE)})), (Map)ImmutableMap.of((Object)C, (Object)new AggregationNode.Aggregation(TestEffectivePredicateExtractor.fakeFunction(), TestEffectivePredicateExtractor.fakeFunctionHandle("test", FunctionKind.AGGREGATE), Optional.empty()), (Object)D, (Object)new AggregationNode.Aggregation(TestEffectivePredicateExtractor.fakeFunction(), TestEffectivePredicateExtractor.fakeFunctionHandle("test", FunctionKind.AGGREGATE), Optional.empty())), AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)A, (Object)B, (Object)C)), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(2L)), TestEffectivePredicateExtractor.equals(BE, CE)}));
    }

    @Test
    public void testGroupByEmpty() {
        AggregationNode node = new AggregationNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)BooleanLiteral.FALSE_LITERAL), (Map)ImmutableMap.of(), AggregationNode.globalAggregation(), (List)ImmutableList.of(), AggregationNode.Step.FINAL, Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.TRUE_LITERAL);
    }

    @Test
    public void testFilter() {
        FilterNode node = TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, (Expression)new FunctionCall(QualifiedName.of((String)"rand"), (List)ImmutableList.of())), TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.lessThan(BE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testProject() {
        ProjectNode node = new ProjectNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), Assignments.of((Symbol)D, (Expression)AE, (Symbol)E, (Expression)CE));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(DE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(DE, EE)}));
    }

    @Test
    public void testTopN() {
        TopNNode node = new TopNNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, new OrderingScheme((List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST)), TopNNode.Step.PARTIAL);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testLimit() {
        LimitNode node = new LimitNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), 1L, false);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testSort() {
        SortNode node = new SortNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), new OrderingScheme((List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST)));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testWindow() {
        WindowNode node = new WindowNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))})), new WindowNode.Specification((List)ImmutableList.of((Object)A), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)A), (Map)ImmutableMap.of((Object)A, (Object)SortOrder.ASC_NULLS_LAST)))), (Map)ImmutableMap.of(), Optional.empty(), (Set)ImmutableSet.of(), 0);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(AE, BE), TestEffectivePredicateExtractor.equals(BE, CE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
    }

    @Test
    public void testTableScan() {
        Map assignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C, (Object)D)));
        TableScanNode node = TableScanNode.newInstance((PlanNodeId)TestEffectivePredicateExtractor.newId(), (TableHandle)TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), (Map)assignments);
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.TRUE_LITERAL);
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.none()), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.none());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.FALSE_LITERAL);
        TupleDomain predicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, predicate);
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), AE)));
        predicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)this.scanAssignments.get(A), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)this.scanAssignments.get(B), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)predicate), (List)ImmutableList.copyOf(assignments.keySet()), assignments, predicate);
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(2L), BE), TestEffectivePredicateExtractor.equals(TestEffectivePredicateExtractor.bigintLiteral(1L), AE)}));
        node = new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(assignments.keySet()), assignments, TupleDomain.all());
        effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.TRUE_LITERAL);
    }

    @Test
    public void testUnion() {
        ImmutableListMultimap symbolMapping = ImmutableListMultimap.of((Object)A, (Object)B, (Object)A, (Object)C, (Object)A, (Object)E);
        UnionNode node = new UnionNode(TestEffectivePredicateExtractor.newId(), (List)ImmutableList.of((Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L))), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))})), (Object)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))}))), (ListMultimap)symbolMapping, (List)ImmutableList.copyOf((Collection)symbolMapping.keySet()));
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.INNER, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.of(TestEffectivePredicateExtractor.lessThanOrEqual(BE, EE)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.lessThanOrEqual(BE, EE)}));
    }

    @Test
    public void testInnerJoinPropagatesPredicatesViaEquiConditions() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (Expression)TestEffectivePredicateExtractor.equals(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.INNER, (PlanNode)left, (PlanNode)rightScan, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D)), (List)ImmutableList.builder().addAll((Iterable)rightScan.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts((Expression)TestEffectivePredicateExtractor.equals(DE, TestEffectivePredicateExtractor.bigintLiteral(10L))));
    }

    @Test
    public void testInnerJoinWithFalseFilter() {
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.INNER, (PlanNode)leftScan, (PlanNode)rightScan, (List)ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D)), (List)ImmutableList.builder().addAll((Iterable)leftScan.getOutputSymbols()).addAll((Iterable)rightScan.getOutputSymbols()).build(), Optional.of(BooleanLiteral.FALSE_LITERAL), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals((Object)effectivePredicate, (Object)BooleanLiteral.FALSE_LITERAL);
    }

    @Test
    public void testLeftJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull(DE), TestEffectivePredicateExtractor.isNull(EE)})}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), TestEffectivePredicateExtractor.isNull(FE)}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(DE)}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.isNull(EE)})}));
    }

    @Test
    public void testLeftJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, (Expression)BooleanLiteral.FALSE_LITERAL);
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.LEFT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(DE)})}));
    }

    @Test
    public void testRightJoin() {
        ImmutableList.Builder criteriaBuilder = ImmutableList.builder();
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(A, D));
        criteriaBuilder.add((Object)new JoinNode.EquiJoinClause(B, E));
        ImmutableList criteria = criteriaBuilder.build();
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.equals(GE, TestEffectivePredicateExtractor.bigintLiteral(10L))}));
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(BE, AE), ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.isNull(BE), TestEffectivePredicateExtractor.isNull(AE)})}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.lessThan(CE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.isNull(CE)}), TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(AE)}), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(BE, EE), TestEffectivePredicateExtractor.isNull(BE)})}));
    }

    @Test
    public void testRightJoinWithFalseInner() {
        ImmutableList criteria = ImmutableList.of((Object)new JoinNode.EquiJoinClause(A, D));
        Map leftAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)A, (Object)B, (Object)C)));
        TableScanNode leftScan = TestEffectivePredicateExtractor.tableScanNode(leftAssignments);
        Map rightAssignments = Maps.filterKeys(this.scanAssignments, (Predicate)Predicates.in((Collection)ImmutableList.of((Object)D, (Object)E, (Object)F)));
        TableScanNode rightScan = TestEffectivePredicateExtractor.tableScanNode(rightAssignments);
        FilterNode left = TestEffectivePredicateExtractor.filter((PlanNode)leftScan, (Expression)BooleanLiteral.FALSE_LITERAL);
        FilterNode right = TestEffectivePredicateExtractor.filter((PlanNode)rightScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L))}));
        JoinNode node = new JoinNode(TestEffectivePredicateExtractor.newId(), JoinNode.Type.RIGHT, (PlanNode)left, (PlanNode)right, (List)criteria, (List)ImmutableList.builder().addAll((Iterable)left.getOutputSymbols()).addAll((Iterable)right.getOutputSymbols()).build(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(new Expression[]{TestEffectivePredicateExtractor.equals(DE, EE), TestEffectivePredicateExtractor.lessThan(FE, TestEffectivePredicateExtractor.bigintLiteral(100L)), ExpressionUtils.or((Expression[])new Expression[]{TestEffectivePredicateExtractor.equals(AE, DE), TestEffectivePredicateExtractor.isNull(AE)})}));
    }

    @Test
    public void testSemiJoin() {
        SemiJoinNode node = new SemiJoinNode(TestEffectivePredicateExtractor.newId(), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))})), (PlanNode)TestEffectivePredicateExtractor.filter((PlanNode)this.baseTableScan, (Expression)TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(5L))), A, B, C, Optional.empty(), Optional.empty(), Optional.empty());
        Expression effectivePredicate = this.effectivePredicateExtractor.extract(SESSION, (PlanNode)node);
        Assert.assertEquals(this.normalizeConjuncts(effectivePredicate), this.normalizeConjuncts(ExpressionUtils.and((Expression[])new Expression[]{TestEffectivePredicateExtractor.greaterThan(AE, TestEffectivePredicateExtractor.bigintLiteral(10L)), TestEffectivePredicateExtractor.lessThan(AE, TestEffectivePredicateExtractor.bigintLiteral(100L))})));
    }

    private static TableScanNode tableScanNode(Map<Symbol, ColumnHandle> scanAssignments) {
        return new TableScanNode(TestEffectivePredicateExtractor.newId(), TestEffectivePredicateExtractor.makeTableHandle((TupleDomain<ColumnHandle>)TupleDomain.all()), (List)ImmutableList.copyOf(scanAssignments.keySet()), scanAssignments, TupleDomain.all());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }

    private static FilterNode filter(PlanNode source, Expression predicate) {
        return new FilterNode(TestEffectivePredicateExtractor.newId(), source, predicate);
    }

    private static Expression bigintLiteral(long number) {
        if (number < Integer.MAX_VALUE && number > Integer.MIN_VALUE) {
            return new GenericLiteral("BIGINT", String.valueOf(number));
        }
        return new LongLiteral(String.valueOf(number));
    }

    private static ComparisonExpression equals(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, expression1, expression2);
    }

    private static ComparisonExpression lessThan(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, expression1, expression2);
    }

    private static ComparisonExpression lessThanOrEqual(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, expression1, expression2);
    }

    private static ComparisonExpression greaterThan(Expression expression1, Expression expression2) {
        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, expression1, expression2);
    }

    private static IsNullPredicate isNull(Expression expression) {
        return new IsNullPredicate(expression);
    }

    private static FunctionCall fakeFunction() {
        return new FunctionCall(QualifiedName.of((String)"test"), (List)ImmutableList.of());
    }

    private static Signature fakeFunctionHandle(String name, FunctionKind kind) {
        return new Signature(name, kind, TypeSignature.parseTypeSignature((String)"unknown"), (List)ImmutableList.of());
    }

    private Set<Expression> normalizeConjuncts(Expression ... conjuncts) {
        return this.normalizeConjuncts(Arrays.asList(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Collection<Expression> conjuncts) {
        return this.normalizeConjuncts(ExpressionUtils.combineConjuncts(conjuncts));
    }

    private Set<Expression> normalizeConjuncts(Expression predicate) {
        predicate = this.expressionNormalizer.normalize(predicate);
        EqualityInference inference = EqualityInference.createEqualityInference((Expression[])new Expression[]{predicate});
        HashSet<Expression> rewrittenSet = new HashSet<Expression>();
        for (Expression expression : EqualityInference.nonInferrableConjuncts((Expression)predicate)) {
            Expression rewritten = inference.rewriteExpression(expression, Predicates.alwaysTrue());
            Preconditions.checkState((rewritten != null ? 1 : 0) != 0, (Object)"Rewrite with full symbol scope should always be possible");
            rewrittenSet.add(rewritten);
        }
        rewrittenSet.addAll(inference.generateEqualitiesPartitionedBy(Predicates.alwaysTrue()).getScopeEqualities());
        return rewrittenSet;
    }

    private static TableHandle makeTableHandle(TupleDomain<ColumnHandle> predicate) {
        return new TableHandle(new CatalogName("test"), (ConnectorTableHandle)new PredicatedTableHandle(predicate), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.empty());
    }

    private static class PredicatedTableHandle
    implements ConnectorTableHandle {
        private final TupleDomain<ColumnHandle> predicate;

        public PredicatedTableHandle(TupleDomain<ColumnHandle> predicate) {
            this.predicate = predicate;
        }

        public TupleDomain<ColumnHandle> getPredicate() {
            return this.predicate;
        }
    }

    private static class ExpressionIdentityNormalizer {
        private final Map<Expression, Expression> expressionCache = new HashMap<Expression, Expression>();

        private ExpressionIdentityNormalizer() {
        }

        private Expression normalize(Expression expression) {
            Expression identityNormalizedExpression = this.expressionCache.get(expression);
            if (identityNormalizedExpression == null) {
                for (Expression subExpression : Iterables.filter((Iterable)SubExpressionExtractor.extract((Expression)expression), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)expression)))) {
                    this.normalize(subExpression);
                }
                identityNormalizedExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionNodeInliner(this.expressionCache), (Expression)expression);
                this.expressionCache.put(identityNormalizedExpression, identityNormalizedExpression);
            }
            return identityNormalizedExpression;
        }
    }
}

