/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Joiner;
import io.airlift.testing.Closeables;
import io.prestosql.SessionTestUtils;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.testing.LocalQueryRunner;
import java.io.Closeable;
import java.util.Collections;
import org.intellij.lang.annotations.Language;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestLocalExecutionPlanner {
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = new LocalQueryRunner(SessionTestUtils.TEST_SESSION);
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.runner});
        this.runner = null;
    }

    @Test
    public void testCompilerFailure() {
        String inner = "(" + Joiner.on((String)" + ").join(Collections.nCopies(100, "rand()")) + ")";
        String outer = Joiner.on((String)" + ").join(Collections.nCopies(100, inner));
        this.assertFails("SELECT " + outer, (ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR);
    }

    private void assertFails(@Language(value="SQL") String sql, ErrorCodeSupplier supplier) {
        try {
            this.runner.execute(sql);
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)supplier.toErrorCode());
        }
    }
}

