/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPredicatePushdown
extends BasePlanTest {
    @Test
    public void testCoercions() {
        this.assertPlan("WITH     t(k, v) AS (VALUES (1, 'aaaa')),    u(k, v) AS (VALUES (1, 'bbbb')) SELECT 1 FROM t JOIN u ON t.k = u.k AND t.v = u.v WHERE t.v = 'x'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t_k", "u_k")), PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(4)) = t_v", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t_k", (Object)"t_v"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("aaaa")))))), PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(4)) = u_v", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"u_k", (Object)"u_v"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("bbbb")))))))));
        this.assertPlan("WITH     t(k, v) AS (VALUES (1, 'aaaa')),    u(k, v) AS (VALUES (1, 'bbbbb')) SELECT 1 FROM t JOIN u ON t.k = u.k AND t.v = u.v WHERE t.v = 'x'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("t_k", "u_k")), PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(4)) = t_v", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"t_k", (Object)"t_v"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("aaaa")))))), PlanMatchPattern.project(PlanMatchPattern.filter("CAST('x' AS varchar(5)) = u_v", PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"u_k", (Object)"u_v"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("bbbbb")))))))));
    }

    @Test
    public void testNonStraddlingJoinExpression() {
        this.assertPlan("SELECT * FROM orders JOIN lineitem ON orders.orderkey = lineitem.orderkey AND cast(lineitem.linenumber AS varchar) = '2'", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("ORDERS_OK", "LINEITEM_OK")), PlanMatchPattern.any(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_OK", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("cast('2' as varchar) = cast(LINEITEM_LINENUMBER as varchar)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINEITEM_OK", (Object)"orderkey", (Object)"LINEITEM_LINENUMBER", (Object)"linenumber")))))));
    }

    @Test
    public void testPushDownToLhsOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders)) WHERE linenumber = 2", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_NUMBER = 2", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_NUMBER", (Object)"linenumber", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))));
    }

    @Test
    public void testNonDeterministicPredicatePropagatesOnlyToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey = random(5)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testNonDeterministicPredicateDoesNotPropagateFromFilteringSideToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = random(5))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.filter("ORDERS_ORDER_KEY = CAST(random(5) AS bigint)", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey"))))))));
    }

    @Test
    public void testGreaterPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualsPredicateFromFilterSidePropagatesToSourceSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders WHERE orderkey = 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders WHERE orderkey > 2))", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testGreaterPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testEqualPredicateFromSourceSidePropagatesToFilterSideOfSemiJoin() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey IN (SELECT orderkey FROM orders) AND orderkey = 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.anyTree(PlanMatchPattern.filter("LINE_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY = BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromSourceSideNotPropagatesToFilterSideOfSemiJoinIfNotIn() {
        this.assertPlan("SELECT quantity FROM (SELECT * FROM lineitem WHERE orderkey NOT IN (SELECT orderkey FROM orders) AND orderkey > 2)", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.filter("LINE_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey", (Object)"LINE_QUANTITY", (Object)"quantity")))), PlanMatchPattern.node(ExchangeNode.class, PlanMatchPattern.project(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testPredicateFromFilterSideNotPropagatesToSourceSideOfSemiJoinUsedInProjection() {
        this.assertPlan("SELECT orderkey IN (SELECT orderkey FROM orders WHERE orderkey > 2) FROM lineitem", PlanMatchPattern.anyTree(PlanMatchPattern.semiJoin("LINE_ORDER_KEY", "ORDERS_ORDER_KEY", "SEMI_JOIN_RESULT", PlanMatchPattern.project(PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"LINE_ORDER_KEY", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDERS_ORDER_KEY > BIGINT '2'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERS_ORDER_KEY", (Object)"orderkey")))))));
    }

    @Test
    public void testFilteredSelectFromPartitionedTable() {
        List allOptimizers = this.getQueryRunner().getPlanOptimizers(false);
        this.assertPlan("SELECT DISTINCT orderstatus FROM orders", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders")), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'O'", PlanMatchPattern.output(PlanMatchPattern.exchange(PlanMatchPattern.tableScan("orders"))), allOptimizers);
        this.assertPlan("SELECT orderstatus FROM orders WHERE orderstatus = 'no_such_partition_value'", PlanMatchPattern.output(PlanMatchPattern.values("orderstatus")), allOptimizers);
    }

    @Test
    public void testPredicatePushDownThroughMarkDistinct() {
        this.assertPlan("SELECT (SELECT a FROM (VALUES 1, 2, 3) t(a) WHERE a = b) FROM (VALUES 0, 1) p(b) WHERE b = 1", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A", "B")), PlanMatchPattern.project(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.filter("A = 1", PlanMatchPattern.values("A")))), PlanMatchPattern.project(PlanMatchPattern.filter("1 = B", PlanMatchPattern.values("B"))))));
    }

    @Test
    public void testPredicatePushDownOverProjection() {
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x + x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("((expr + expr) > BIGINT '1')", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("orderkey * BIGINT '2'")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, 1 y FROM orders) SELECT * FROM t WHERE x + y + y >1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("(((orderkey * BIGINT '2') + BIGINT '1') + BIGINT '1') > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey * 2 x FROM orders) SELECT * FROM t WHERE x > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("(orderkey * BIGINT '2') > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("with t AS (SELECT orderkey * 2 x, orderkey y FROM orders) SELECT * FROM t WHERE x + y > 1", PlanMatchPattern.anyTree(PlanMatchPattern.project(PlanMatchPattern.filter("((orderkey * BIGINT '2') + orderkey) > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey"))))));
        this.assertPlan("WITH t AS (SELECT orderkey x FROM orders) SELECT * FROM t WHERE x >1", PlanMatchPattern.anyTree(PlanMatchPattern.filter("orderkey > BIGINT '1'", PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey")))));
        this.assertPlan("WITH t AS (SELECT rand() * orderkey x FROM orders) SELECT * FROM t WHERE x > 5000", PlanMatchPattern.anyTree(PlanMatchPattern.filter("expr > 5E3", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression("rand() * CAST(orderkey AS double)")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"ORDERKEY", (Object)"orderkey"))))));
    }

    @Test
    public void testConjunctsOrder() {
        this.assertPlan("select partkey from (  select    partkey,    100/(size-1) x  from part  where size <> 1) where x = 2", PlanMatchPattern.anyTree(PlanMatchPattern.filter("size <> 1 AND 100/(size - 1) = 2", PlanMatchPattern.tableScan("part", (Map<String, String>)ImmutableMap.of((Object)"partkey", (Object)"partkey", (Object)"size", (Object)"size")))));
    }

    @Test
    public void testPredicateOnPartitionSymbolsPushedThroughWindow() {
        PlanMatchPattern tableScan = PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey", (Object)"ORDER_KEY", (Object)"orderkey"));
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey = 0 AND orderkey > 0", PlanMatchPattern.anyTree(PlanMatchPattern.filter("ORDER_KEY > BIGINT '0'", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("CUST_KEY = BIGINT '0'", tableScan)))))));
    }

    @Test
    public void testPredicateOnNonDeterministicSymbolsPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT random_column, orderkey, rank() OVER (PARTITION BY random_column  ORDER BY orderdate ASC)FROM (select round(custkey*rand()) random_column, * from orders) ) WHERE random_column > 100", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.filter("\"ROUND\" > 1E2", PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ROUND", (Object)PlanMatchPattern.expression("round(CAST(CUST_KEY AS double) * rand())")), PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }

    @Test
    public void testNonDeterministicPredicateNotPushedDown() {
        this.assertPlan("SELECT * FROM (SELECT custkey, orderkey, rank() OVER (PARTITION BY custkey  ORDER BY orderdate ASC)FROM orders) WHERE custkey > 100*rand()", PlanMatchPattern.anyTree(PlanMatchPattern.filter("CAST(\"CUST_KEY\" AS double) > (1E2 * \"rand\"())", PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"CUST_KEY", (Object)"custkey"))))))));
    }
}

