/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.SortExpressionContext;
import io.prestosql.sql.planner.SortExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSortExpressionExtractor {
    private static final Set<Symbol> BUILD_SYMBOLS = ImmutableSet.of((Object)new Symbol("b1"), (Object)new Symbol("b2"));

    @Test
    public void testGetSortExpression() {
        this.assertGetSortExpression("p1 > b1", "b1");
        this.assertGetSortExpression("b2 <= p1", "b2");
        this.assertGetSortExpression("b2 > p1", "b2");
        this.assertGetSortExpression("b2 > sin(p1)", "b2");
        this.assertNoSortExpression("b2 > random(p1)");
        this.assertGetSortExpression("b2 > random(p1) AND b2 > p1", "b2", "b2 > p1");
        this.assertGetSortExpression("b2 > random(p1) AND b1 > p1", "b1", "b1 > p1");
        this.assertNoSortExpression("b1 > p1 + b2");
        this.assertNoSortExpression("sin(b1) > p1");
        this.assertNoSortExpression("b1 <= p1 OR b2 <= p1");
        this.assertNoSortExpression("sin(b2) > p1 AND (b2 <= p1 OR b2 <= p1 + 10)");
        this.assertGetSortExpression("sin(b2) > p1 AND (b2 <= p1 AND b2 <= p1 + 10)", "b2", "b2 <= p1", "b2 <= p1 + 10");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1", "b1");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1 AND b2 > p1", "b1", "b1 > p1", "b1 <= p1");
        this.assertGetSortExpression("b1 > p1 AND b1 <= p1 AND b2 > p1 AND b2 < p1 + 10 AND b2 > p2", "b2", "b2 > p1", "b2 < p1 + 10", "b2 > p2");
    }

    private Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql));
    }

    private void assertNoSortExpression(String expression) {
        this.assertNoSortExpression(this.expression(expression));
    }

    private void assertNoSortExpression(Expression expression) {
        Optional actual = SortExpressionExtractor.extractSortExpression(BUILD_SYMBOLS, (Expression)expression);
        Assert.assertEquals((Object)actual, Optional.empty());
    }

    private void assertGetSortExpression(String expression, String expectedSymbol) {
        this.assertGetSortExpression(this.expression(expression), expectedSymbol);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol) {
        TestSortExpressionExtractor.assertGetSortExpression(expression, expectedSymbol, ExpressionUtils.extractConjuncts((Expression)expression));
    }

    private void assertGetSortExpression(String expression, String expectedSymbol, String ... searchExpressions) {
        this.assertGetSortExpression(this.expression(expression), expectedSymbol, searchExpressions);
    }

    private void assertGetSortExpression(Expression expression, String expectedSymbol, String ... searchExpressions) {
        List searchExpressionList = (List)Arrays.stream(searchExpressions).map(this::expression).collect(ImmutableList.toImmutableList());
        TestSortExpressionExtractor.assertGetSortExpression(expression, expectedSymbol, searchExpressionList);
    }

    private static void assertGetSortExpression(Expression expression, String expectedSymbol, List<Expression> searchExpressions) {
        Optional<SortExpressionContext> expected = Optional.of(new SortExpressionContext((Expression)new SymbolReference(expectedSymbol), searchExpressions));
        Optional actual = SortExpressionExtractor.extractSortExpression(BUILD_SYMBOLS, (Expression)expression);
        Assert.assertEquals((Object)actual, expected);
    }
}

