/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.planner.LogicalPlanner;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.assertions.PlanAssert;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.optimizations.PruneUnreferencedOutputs;
import io.prestosql.sql.planner.optimizations.UnaliasSymbolReferences;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class BasePlanTest {
    private final LocalQueryRunnerSupplier queryRunnerSupplier;
    private LocalQueryRunner queryRunner;

    public BasePlanTest() {
        this((Map<String, String>)ImmutableMap.of());
    }

    public BasePlanTest(Map<String, String> sessionProperties) {
        this.queryRunnerSupplier = () -> BasePlanTest.createQueryRunner(sessionProperties);
    }

    public BasePlanTest(LocalQueryRunnerSupplier supplier) {
        this.queryRunnerSupplier = Objects.requireNonNull(supplier, "queryRunnerSupplier is null");
    }

    private static LocalQueryRunner createQueryRunner(Map<String, String> sessionProperties) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1");
        sessionProperties.entrySet().forEach(entry -> sessionBuilder.setSystemProperty((String)entry.getKey(), (String)entry.getValue()));
        LocalQueryRunner queryRunner = new LocalQueryRunner(sessionBuilder.build());
        queryRunner.createCatalog((String)queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @BeforeClass
    public final void initPlanTest() throws Exception {
        this.queryRunner = this.queryRunnerSupplier.get();
    }

    @AfterClass(alwaysRun=true)
    public final void destroyPlanTest() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    public CatalogName getCurrentConnectorId() {
        return (CatalogName)((Optional)this.queryRunner.inTransaction(transactionSession -> this.queryRunner.getMetadata().getCatalogHandle(transactionSession, (String)transactionSession.getCatalog().get()))).get();
    }

    protected LocalQueryRunner getQueryRunner() {
        return this.queryRunner;
    }

    protected void assertPlan(String sql, PlanMatchPattern pattern) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, pattern);
    }

    protected void assertPlan(String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern) {
        List optimizers = this.queryRunner.getPlanOptimizers(true);
        this.assertPlan(sql, stage, pattern, optimizers);
    }

    protected void assertPlan(String sql, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED, pattern, optimizers);
    }

    protected void assertPlan(String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern, Predicate<PlanOptimizer> optimizerPredicate) {
        List<PlanOptimizer> optimizers = this.queryRunner.getPlanOptimizers(true).stream().filter(optimizerPredicate).collect(Collectors.toList());
        this.assertPlan(sql, stage, pattern, optimizers);
    }

    protected void assertPlan(String sql, LogicalPlanner.Stage stage, PlanMatchPattern pattern, List<PlanOptimizer> optimizers) {
        this.queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, optimizers, stage, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    protected void assertDistributedPlan(String sql, PlanMatchPattern pattern) {
        this.assertDistributedPlan(sql, this.getQueryRunner().getDefaultSession(), pattern);
    }

    protected void assertDistributedPlan(String sql, Session session, PlanMatchPattern pattern) {
        this.assertPlanWithSession(sql, session, false, pattern);
    }

    protected void assertMinimallyOptimizedPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(), (Object)new PruneUnreferencedOutputs(), (Object)new IterativeOptimizer(new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections())));
        this.assertPlan(sql, LogicalPlanner.Stage.OPTIMIZED, pattern, (List<PlanOptimizer>)optimizers);
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }

    protected void assertPlanWithSession(@Language(value="SQL") String sql, Session session, boolean forceSingleNode, PlanMatchPattern pattern, Consumer<Plan> planValidator) {
        this.queryRunner.inTransaction(session, transactionSession -> {
            Plan actualPlan = this.queryRunner.createPlan(transactionSession, sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, forceSingleNode, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, this.queryRunner.getMetadata(), this.queryRunner.getStatsCalculator(), actualPlan, pattern);
            planValidator.accept(actualPlan);
            return null;
        });
    }

    protected Plan plan(String sql) {
        return this.plan(sql, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED);
    }

    protected Plan plan(String sql, LogicalPlanner.Stage stage) {
        return this.plan(sql, stage, true);
    }

    protected Plan plan(String sql, LogicalPlanner.Stage stage, boolean forceSingleNode) {
        try {
            return (Plan)this.queryRunner.inTransaction(transactionSession -> this.queryRunner.createPlan(transactionSession, sql, stage, forceSingleNode, WarningCollector.NOOP));
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + sql, e);
        }
    }

    public static interface LocalQueryRunnerSupplier {
        public LocalQueryRunner get() throws Exception;
    }
}

