/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.RvalueMatcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ColumnReference
implements RvalueMatcher {
    private final String tableName;
    private final String columnName;

    public ColumnReference(String tableName, String columnName) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Map assignments;
        TableHandle tableHandle;
        if (node instanceof TableScanNode) {
            TableScanNode tableScanNode = (TableScanNode)node;
            tableHandle = tableScanNode.getTable();
            assignments = tableScanNode.getAssignments();
        } else if (node instanceof IndexSourceNode) {
            IndexSourceNode indexSourceNode = (IndexSourceNode)node;
            tableHandle = indexSourceNode.getTableHandle();
            assignments = indexSourceNode.getAssignments();
        } else {
            return Optional.empty();
        }
        TableMetadata tableMetadata = metadata.getTableMetadata(session, tableHandle);
        String actualTableName = tableMetadata.getTable().getTableName();
        if (!this.tableName.equalsIgnoreCase(actualTableName)) {
            return Optional.empty();
        }
        Optional<ColumnHandle> columnHandle = this.getColumnHandle(tableHandle, session, metadata);
        Preconditions.checkState((boolean)columnHandle.isPresent(), (String)"Table %s doesn't have column %s. Typo in test?", (Object)this.tableName, (Object)this.columnName);
        return this.getAssignedSymbol(assignments, columnHandle.get());
    }

    private Optional<Symbol> getAssignedSymbol(Map<Symbol, ColumnHandle> assignments, ColumnHandle columnHandle) {
        Optional<Symbol> result = Optional.empty();
        for (Map.Entry<Symbol, ColumnHandle> entry : assignments.entrySet()) {
            if (!entry.getValue().equals(columnHandle)) continue;
            Preconditions.checkState((!result.isPresent() ? 1 : 0) != 0, (String)"Multiple ColumnHandles found for %s:%s in table scan assignments", (Object)this.tableName, (Object)this.columnName);
            result = Optional.of(entry.getKey());
        }
        return result;
    }

    private Optional<ColumnHandle> getColumnHandle(TableHandle tableHandle, Session session, Metadata metadata) {
        return metadata.getColumnHandles(session, tableHandle).entrySet().stream().filter(entry -> this.columnName.equals(entry.getKey())).map(Map.Entry::getValue).findFirst();
    }

    public String toString() {
        return String.format("Column %s:%s", this.tableName, this.columnName);
    }
}

