/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Objects;

final class ExchangeMatcher
implements Matcher {
    private final ExchangeNode.Scope scope;
    private final ExchangeNode.Type type;
    private final List<PlanMatchPattern.Ordering> orderBy;

    public ExchangeMatcher(ExchangeNode.Scope scope, ExchangeNode.Type type, List<PlanMatchPattern.Ordering> orderBy) {
        this.scope = scope;
        this.type = type;
        this.orderBy = Objects.requireNonNull(orderBy, "orderBy is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof ExchangeNode)) {
            return false;
        }
        ExchangeNode exchangeNode = (ExchangeNode)node;
        return exchangeNode.getScope() == this.scope && exchangeNode.getType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        ExchangeNode exchangeNode = (ExchangeNode)node;
        if (!this.orderBy.isEmpty()) {
            if (!exchangeNode.getOrderingScheme().isPresent()) {
                return MatchResult.NO_MATCH;
            }
            if (!Util.orderingSchemeMatches(this.orderBy, (OrderingScheme)exchangeNode.getOrderingScheme().get(), symbolAliases)) {
                return MatchResult.NO_MATCH;
            }
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scope", (Object)this.scope).add("type", (Object)this.type).add("orderBy", this.orderBy).toString();
    }
}

