/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class ExpressionVerifier
extends AstVisitor<Boolean, Node> {
    private final SymbolAliases symbolAliases;

    ExpressionVerifier(SymbolAliases symbolAliases) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolAliases is null");
    }

    protected Boolean visitNode(Node node, Node context) {
        throw new IllegalStateException(String.format("Node %s is not supported", node));
    }

    protected Boolean visitTryExpression(TryExpression actual, Node expected) {
        if (!(expected instanceof TryExpression)) {
            return false;
        }
        return (Boolean)this.process((Node)actual.getInnerExpression(), ((TryExpression)expected).getInnerExpression());
    }

    protected Boolean visitCast(Cast actual, Node expectedExpression) {
        if (!(expectedExpression instanceof Cast)) {
            return false;
        }
        Cast expected = (Cast)expectedExpression;
        if (!actual.getType().equals(expected.getType())) {
            return false;
        }
        return (Boolean)this.process((Node)actual.getExpression(), expected.getExpression());
    }

    protected Boolean visitIsNullPredicate(IsNullPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IsNullPredicate)) {
            return false;
        }
        IsNullPredicate expected = (IsNullPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IsNotNullPredicate)) {
            return false;
        }
        IsNotNullPredicate expected = (IsNotNullPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitInPredicate(InPredicate actual, Node expectedExpression) {
        if (expectedExpression instanceof InPredicate) {
            InPredicate expected = (InPredicate)expectedExpression;
            if (actual.getValueList() instanceof InListExpression) {
                return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getValueList(), expected.getValueList()) != false;
            }
            Preconditions.checkState((boolean)(expected.getValueList() instanceof InListExpression), (Object)"ExpressionVerifier doesn't support unpacked expected values. Feel free to add support if needed");
            List values = ((InListExpression)expected.getValueList()).getValues();
            Preconditions.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Multiple expressions in expected value list %s, but actual value is not a list", (Object)values, (Object)actual.getValue());
            Expression onlyExpectedExpression = (Expression)values.get(0);
            return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getValueList(), onlyExpectedExpression) != false;
        }
        return false;
    }

    protected Boolean visitComparisonExpression(ComparisonExpression actual, Node expectedExpression) {
        if (expectedExpression instanceof ComparisonExpression) {
            ComparisonExpression expected = (ComparisonExpression)expectedExpression;
            return actual.getOperator() == expected.getOperator() && (Boolean)this.process((Node)actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getRight()) != false || actual.getOperator() == expected.getOperator().flip() && (Boolean)this.process((Node)actual.getLeft(), expected.getRight()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getLeft()) != false;
        }
        return false;
    }

    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression actual, Node expectedExpression) {
        if (expectedExpression instanceof ArithmeticBinaryExpression) {
            ArithmeticBinaryExpression expected = (ArithmeticBinaryExpression)expectedExpression;
            if (actual.getOperator() == expected.getOperator()) {
                return (Boolean)this.process((Node)actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getRight()) != false;
            }
        }
        return false;
    }

    protected Boolean visitGenericLiteral(GenericLiteral actual, Node expected) {
        if (expected instanceof GenericLiteral) {
            return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expected));
        }
        return false;
    }

    protected Boolean visitLongLiteral(LongLiteral actual, Node expected) {
        if (expected instanceof LongLiteral) {
            return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expected));
        }
        return false;
    }

    protected Boolean visitDoubleLiteral(DoubleLiteral actual, Node expected) {
        if (expected instanceof DoubleLiteral) {
            return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expected));
        }
        return false;
    }

    protected Boolean visitDecimalLiteral(DecimalLiteral actual, Node expected) {
        if (expected instanceof DecimalLiteral) {
            return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expected));
        }
        return false;
    }

    protected Boolean visitBooleanLiteral(BooleanLiteral actual, Node expected) {
        if (expected instanceof BooleanLiteral) {
            return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expected));
        }
        return false;
    }

    private static String getValueFromLiteral(Node expression) {
        if (expression instanceof LongLiteral) {
            return String.valueOf(((LongLiteral)expression).getValue());
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).getValue());
        }
        if (expression instanceof DoubleLiteral) {
            return String.valueOf(((DoubleLiteral)expression).getValue());
        }
        if (expression instanceof DecimalLiteral) {
            return String.valueOf(((DecimalLiteral)expression).getValue());
        }
        if (expression instanceof GenericLiteral) {
            return ((GenericLiteral)expression).getValue();
        }
        throw new IllegalArgumentException("Unsupported literal expression type: " + expression.getClass().getName());
    }

    protected Boolean visitStringLiteral(StringLiteral actual, Node expectedExpression) {
        if (expectedExpression instanceof StringLiteral) {
            StringLiteral expected = (StringLiteral)expectedExpression;
            return actual.getValue().equals(expected.getValue());
        }
        return false;
    }

    protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression actual, Node expectedExpression) {
        if (expectedExpression instanceof LogicalBinaryExpression) {
            LogicalBinaryExpression expected = (LogicalBinaryExpression)expectedExpression;
            if (actual.getOperator() == expected.getOperator()) {
                return (Boolean)this.process((Node)actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getRight()) != false;
            }
        }
        return false;
    }

    protected Boolean visitBetweenPredicate(BetweenPredicate actual, Node expectedExpression) {
        if (expectedExpression instanceof BetweenPredicate) {
            BetweenPredicate expected = (BetweenPredicate)expectedExpression;
            return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getMin(), expected.getMin()) != false && (Boolean)this.process((Node)actual.getMax(), expected.getMax()) != false;
        }
        return false;
    }

    protected Boolean visitNotExpression(NotExpression actual, Node expected) {
        if (expected instanceof NotExpression) {
            return (Boolean)this.process((Node)actual.getValue(), ((NotExpression)expected).getValue());
        }
        return false;
    }

    protected Boolean visitSymbolReference(SymbolReference actual, Node expected) {
        if (!(expected instanceof SymbolReference)) {
            return false;
        }
        return this.symbolAliases.get(((SymbolReference)expected).getName()).equals((Object)actual);
    }

    protected Boolean visitCoalesceExpression(CoalesceExpression actual, Node expected) {
        if (!(expected instanceof CoalesceExpression)) {
            return false;
        }
        CoalesceExpression expectedCoalesce = (CoalesceExpression)expected;
        if (actual.getOperands().size() == expectedCoalesce.getOperands().size()) {
            boolean verified = true;
            for (int i = 0; i < actual.getOperands().size(); ++i) {
                verified &= ((Boolean)this.process((Node)actual.getOperands().get(i), expectedCoalesce.getOperands().get(i))).booleanValue();
            }
            return verified;
        }
        return false;
    }

    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression actual, Node expected) {
        if (!(expected instanceof SimpleCaseExpression)) {
            return false;
        }
        SimpleCaseExpression expectedCase = (SimpleCaseExpression)expected;
        if (!((Boolean)this.process((Node)actual.getOperand(), expectedCase.getOperand())).booleanValue()) {
            return false;
        }
        if (!this.process(actual.getWhenClauses(), expectedCase.getWhenClauses())) {
            return false;
        }
        return this.process(actual.getDefaultValue(), expectedCase.getDefaultValue());
    }

    protected Boolean visitWhenClause(WhenClause actual, Node expected) {
        if (!(expected instanceof WhenClause)) {
            return false;
        }
        WhenClause expectedWhenClause = (WhenClause)expected;
        return (Boolean)this.process((Node)actual.getOperand(), expectedWhenClause.getOperand()) != false && (Boolean)this.process((Node)actual.getResult(), expectedWhenClause.getResult()) != false;
    }

    protected Boolean visitFunctionCall(FunctionCall actual, Node expected) {
        if (!(expected instanceof FunctionCall)) {
            return false;
        }
        FunctionCall expectedFunction = (FunctionCall)expected;
        if (actual.isDistinct() != expectedFunction.isDistinct()) {
            return false;
        }
        if (!actual.getName().equals((Object)expectedFunction.getName())) {
            return false;
        }
        if (!this.process(actual.getArguments(), expectedFunction.getArguments())) {
            return false;
        }
        if (!this.process(actual.getFilter(), expectedFunction.getFilter())) {
            return false;
        }
        if (!this.process(actual.getWindow(), expectedFunction.getWindow())) {
            return false;
        }
        return true;
    }

    protected Boolean visitNullLiteral(NullLiteral node, Node expected) {
        return expected instanceof NullLiteral;
    }

    protected Boolean visitInListExpression(InListExpression actual, Node expected) {
        if (!(expected instanceof InListExpression)) {
            return false;
        }
        InListExpression expectedInList = (InListExpression)expected;
        return this.process(actual.getValues(), expectedInList.getValues());
    }

    private <T extends Node> boolean process(List<T> actuals, List<T> expecteds) {
        if (actuals.size() != expecteds.size()) {
            return false;
        }
        for (int i = 0; i < actuals.size(); ++i) {
            if (((Boolean)this.process((Node)actuals.get(i), expecteds.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean process(Optional<T> actual, Optional<T> expected) {
        if (actual.isPresent() != expected.isPresent()) {
            return false;
        }
        if (actual.isPresent()) {
            return (Boolean)this.process((Node)actual.get(), expected.get());
        }
        return true;
    }
}

