/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import java.util.Objects;

final class FilterMatcher
implements Matcher {
    private final Expression predicate;

    FilterMatcher(Expression predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof FilterNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        FilterNode filterNode = (FilterNode)node;
        ExpressionVerifier verifier = new ExpressionVerifier(symbolAliases);
        return new MatchResult((Boolean)verifier.process((Node)filterNode.getPredicate(), this.predicate));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("predicate", (Object)this.predicate).toString();
    }
}

