/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.IndexSourceNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class IndexSourceMatcher
implements Matcher {
    private final String expectedTableName;
    private final Optional<Map<String, Domain>> expectedConstraint;

    public IndexSourceMatcher(String expectedTableName) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        this.expectedConstraint = Optional.empty();
    }

    public IndexSourceMatcher(String expectedTableName, Map<String, Domain> expectedConstraint) {
        this.expectedTableName = Objects.requireNonNull(expectedTableName, "expectedTableName is null");
        this.expectedConstraint = Optional.of(ImmutableMap.copyOf(expectedConstraint));
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof IndexSourceNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        IndexSourceNode indexSourceNode = (IndexSourceNode)node;
        TableMetadata tableMetadata = metadata.getTableMetadata(session, indexSourceNode.getTableHandle());
        String actualTableName = tableMetadata.getTable().getTableName();
        if (!this.expectedTableName.equalsIgnoreCase(actualTableName)) {
            return MatchResult.NO_MATCH;
        }
        if (this.expectedConstraint.isPresent() && !Util.domainsMatch(this.expectedConstraint, (TupleDomain<ColumnHandle>)indexSourceNode.getCurrentConstraint(), indexSourceNode.getTableHandle(), session, metadata)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("expectedTableName", (Object)this.expectedTableName).add("expectedConstraint", this.expectedConstraint.orElse(null)).toString();
    }
}

