/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class JoinMatcher
implements Matcher {
    private final JoinNode.Type joinType;
    private final List<ExpectedValueProvider<JoinNode.EquiJoinClause>> equiCriteria;
    private final Optional<Expression> filter;
    private final Optional<JoinNode.DistributionType> distributionType;
    private final Optional<Boolean> spillable;

    JoinMatcher(JoinNode.Type joinType, List<ExpectedValueProvider<JoinNode.EquiJoinClause>> equiCriteria, Optional<Expression> filter, Optional<JoinNode.DistributionType> distributionType, Optional<Boolean> spillable) {
        this.joinType = Objects.requireNonNull(joinType, "joinType is null");
        this.equiCriteria = Objects.requireNonNull(equiCriteria, "equiCriteria is null");
        this.filter = Objects.requireNonNull(filter, "filter can not be null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
        this.spillable = Objects.requireNonNull(spillable, "spillable is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof JoinNode)) {
            return false;
        }
        JoinNode joinNode = (JoinNode)node;
        return joinNode.getType() == this.joinType;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        JoinNode joinNode = (JoinNode)node;
        if (joinNode.getCriteria().size() != this.equiCriteria.size()) {
            return MatchResult.NO_MATCH;
        }
        if (this.filter.isPresent()) {
            if (!joinNode.getFilter().isPresent()) {
                return MatchResult.NO_MATCH;
            }
            if (!((Boolean)new ExpressionVerifier(symbolAliases).process((Node)joinNode.getFilter().get(), this.filter.get())).booleanValue()) {
                return MatchResult.NO_MATCH;
            }
        } else if (joinNode.getFilter().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (this.distributionType.isPresent() && !this.distributionType.equals(joinNode.getDistributionType())) {
            return MatchResult.NO_MATCH;
        }
        if (this.spillable.isPresent() && !this.spillable.equals(joinNode.isSpillable())) {
            return MatchResult.NO_MATCH;
        }
        ImmutableSet actual = ImmutableSet.copyOf((Collection)joinNode.getCriteria());
        Set expected = (Set)this.equiCriteria.stream().map(maker -> (JoinNode.EquiJoinClause)maker.getExpectedValue(symbolAliases)).collect(ImmutableSet.toImmutableSet());
        return new MatchResult(expected.equals(actual));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.joinType).add("equiCriteria", this.equiCriteria).add("filter", this.filter.orElse(null)).add("distributionType", this.distributionType).toString();
    }
}

