/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.PlanNode;

public class LimitMatcher
implements Matcher {
    private final long limit;
    private final boolean partial;

    public LimitMatcher(long limit, boolean partial) {
        this.limit = limit;
        this.partial = partial;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof LimitNode)) {
            return false;
        }
        LimitNode limitNode = (LimitNode)node;
        return limitNode.getCount() == this.limit && limitNode.isPartial() == this.partial;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        return MatchResult.match();
    }
}

