/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.PlanMatchingState;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.iterative.GroupReference;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Objects;

final class PlanMatchingVisitor
extends PlanVisitor<MatchResult, PlanMatchPattern> {
    private final Metadata metadata;
    private final Session session;
    private final StatsProvider statsProvider;
    private final Lookup lookup;

    PlanMatchingVisitor(Session session, Metadata metadata, StatsProvider statsProvider, Lookup lookup) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.statsProvider = Objects.requireNonNull(statsProvider, "statsProvider is null");
        this.lookup = Objects.requireNonNull(lookup, "lookup is null");
    }

    public MatchResult visitExchange(ExchangeNode node, PlanMatchPattern pattern) {
        List allInputs = node.getInputs();
        List outputs = node.getOutputSymbols();
        MatchResult result = (MatchResult)super.visitExchange(node, (Object)pattern);
        if (!result.isMatch()) {
            return result;
        }
        SymbolAliases newAliases = result.getAliases();
        for (List inputs : allInputs) {
            Assignments.Builder assignments = Assignments.builder();
            for (int i = 0; i < inputs.size(); ++i) {
                assignments.put((Symbol)outputs.get(i), (Expression)((Symbol)inputs.get(i)).toSymbolReference());
            }
            newAliases = newAliases.updateAssignments(assignments.build());
        }
        return MatchResult.match(newAliases);
    }

    public MatchResult visitProject(ProjectNode node, PlanMatchPattern pattern) {
        MatchResult result = (MatchResult)super.visitProject(node, (Object)pattern);
        if (!result.isMatch()) {
            return result;
        }
        return MatchResult.match(result.getAliases().replaceAssignments(node.getAssignments()));
    }

    public MatchResult visitGroupReference(GroupReference node, PlanMatchPattern pattern) {
        MatchResult match = (MatchResult)this.lookup.resolve((PlanNode)node).accept((PlanVisitor)this, (Object)pattern);
        if (match.isMatch()) {
            return match;
        }
        return this.matchLeaf((PlanNode)node, pattern, pattern.shapeMatches((PlanNode)node));
    }

    protected MatchResult visitPlan(PlanNode node, PlanMatchPattern pattern) {
        List<PlanMatchingState> states = pattern.shapeMatches(node);
        if (states.isEmpty()) {
            return MatchResult.NO_MATCH;
        }
        if (node.getSources().isEmpty()) {
            return this.matchLeaf(node, pattern, states);
        }
        MatchResult result = MatchResult.NO_MATCH;
        for (PlanMatchingState state : states) {
            SymbolAliases allSourceAliases;
            MatchResult matchResult;
            MatchResult sourcesMatch = this.matchSources(node, state);
            if (!sourcesMatch.isMatch() || !(matchResult = pattern.detailMatches(node, this.statsProvider, this.session, this.metadata, allSourceAliases = sourcesMatch.getAliases())).isMatch()) continue;
            Preconditions.checkState((result == MatchResult.NO_MATCH ? 1 : 0) != 0, (String)"Ambiguous match on node %s", (Object)node);
            result = MatchResult.match(allSourceAliases.withNewAliases(matchResult.getAliases()));
        }
        return result;
    }

    private MatchResult matchLeaf(PlanNode node, PlanMatchPattern pattern, List<PlanMatchingState> states) {
        MatchResult result = MatchResult.NO_MATCH;
        for (PlanMatchingState state : states) {
            MatchResult matchResult;
            if (!state.isTerminated() || !(matchResult = pattern.detailMatches(node, this.statsProvider, this.session, this.metadata, new SymbolAliases())).isMatch()) continue;
            Preconditions.checkState((result == MatchResult.NO_MATCH ? 1 : 0) != 0, (String)"Ambiguous match on leaf node %s", (Object)node);
            result = matchResult;
        }
        return result;
    }

    private MatchResult matchSources(PlanNode node, PlanMatchingState state) {
        List<PlanMatchPattern> sourcePatterns = state.getPatterns();
        Preconditions.checkState((node.getSources().size() == sourcePatterns.size() ? 1 : 0) != 0, (Object)"Matchers count does not match count of sources");
        int i = 0;
        SymbolAliases.Builder allSourceAliases = SymbolAliases.builder();
        for (PlanNode source : node.getSources()) {
            MatchResult matchResult = (MatchResult)source.accept((PlanVisitor)this, (Object)sourcePatterns.get(i++));
            if (!matchResult.isMatch()) {
                return MatchResult.NO_MATCH;
            }
            allSourceAliases.putAll(matchResult.getAliases());
        }
        return MatchResult.match(allSourceAliases.build());
    }
}

