/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SemiJoinNode;
import java.util.Objects;
import java.util.Optional;

final class SemiJoinMatcher
implements Matcher {
    private final String sourceSymbolAlias;
    private final String filteringSymbolAlias;
    private final String outputAlias;
    private final Optional<SemiJoinNode.DistributionType> distributionType;

    SemiJoinMatcher(String sourceSymbolAlias, String filteringSymbolAlias, String outputAlias, Optional<SemiJoinNode.DistributionType> distributionType) {
        this.sourceSymbolAlias = Objects.requireNonNull(sourceSymbolAlias, "sourceSymbolAlias is null");
        this.filteringSymbolAlias = Objects.requireNonNull(filteringSymbolAlias, "filteringSymbolAlias is null");
        this.outputAlias = Objects.requireNonNull(outputAlias, "outputAlias is null");
        this.distributionType = Objects.requireNonNull(distributionType, "distributionType is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof SemiJoinNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SemiJoinNode semiJoinNode = (SemiJoinNode)node;
        if (!symbolAliases.get(this.sourceSymbolAlias).equals((Object)semiJoinNode.getSourceJoinSymbol().toSymbolReference()) || !symbolAliases.get(this.filteringSymbolAlias).equals((Object)semiJoinNode.getFilteringSourceJoinSymbol().toSymbolReference())) {
            return MatchResult.NO_MATCH;
        }
        if (this.distributionType.isPresent() && !this.distributionType.equals(semiJoinNode.getDistributionType())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(this.outputAlias, semiJoinNode.getSemiJoinOutput().toSymbolReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filteringSymbolAlias", (Object)this.filteringSymbolAlias).add("sourceSymbolAlias", (Object)this.sourceSymbolAlias).add("outputAlias", (Object)this.outputAlias).add("distributionType", this.distributionType).toString();
    }
}

