/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.ExpressionVerifier;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.SpatialJoinNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import java.util.Objects;
import java.util.Optional;

public class SpatialJoinMatcher
implements Matcher {
    private final SpatialJoinNode.Type type;
    private final Expression filter;
    private final Optional<String> kdbTree;

    public SpatialJoinMatcher(SpatialJoinNode.Type type, Expression filter, Optional<String> kdbTree) {
        this.type = type;
        this.filter = Objects.requireNonNull(filter, "filter can not be null");
        this.kdbTree = Objects.requireNonNull(kdbTree, "kdbTree can not be null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof SpatialJoinNode)) {
            return false;
        }
        SpatialJoinNode joinNode = (SpatialJoinNode)node;
        return joinNode.getType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        SpatialJoinNode joinNode = (SpatialJoinNode)node;
        if (!((Boolean)new ExpressionVerifier(symbolAliases).process((Node)joinNode.getFilter(), this.filter)).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!joinNode.getKdbTree().equals(this.kdbTree)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).toString();
    }
}

