/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.BaseStrictSymbolsMatcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class StrictSymbolsMatcher
extends BaseStrictSymbolsMatcher {
    private final List<String> expectedAliases;

    public StrictSymbolsMatcher(Function<PlanNode, Set<Symbol>> getActual, List<String> expectedAliases) {
        super(getActual);
        this.expectedAliases = Objects.requireNonNull(expectedAliases, "expectedAliases is null");
    }

    @Override
    protected Set<Symbol> getExpectedSymbols(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return (Set)this.expectedAliases.stream().map(symbolAliases::get).map(Symbol::from).collect(ImmutableSet.toImmutableSet());
    }

    public static Function<PlanNode, Set<Symbol>> actualOutputs() {
        return node -> ImmutableSet.copyOf((Collection)node.getOutputSymbols());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exact outputs", this.expectedAliases).toString();
    }
}

