/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.PlanNode;

final class SymbolCardinalityMatcher
implements Matcher {
    private final int numberOfSymbols;

    SymbolCardinalityMatcher(int numberOfSymbols) {
        this.numberOfSymbols = numberOfSymbols;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return true;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        return new MatchResult(node.getOutputSymbols().size() == this.numberOfSymbols);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfSymbols", this.numberOfSymbols).toString();
    }
}

