/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TopNNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TopNMatcher
implements Matcher {
    private final long count;
    private final List<PlanMatchPattern.Ordering> orderBy;
    private final TopNNode.Step step;

    public TopNMatcher(long count, List<PlanMatchPattern.Ordering> orderBy, TopNNode.Step step) {
        this.count = count;
        this.orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
        this.step = Objects.requireNonNull(step, "step is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TopNNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TopNNode topNNode = (TopNNode)node;
        if (topNNode.getCount() != this.count) {
            return MatchResult.NO_MATCH;
        }
        if (!Util.orderingSchemeMatches(this.orderBy, topNNode.getOrderingScheme(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        if (topNNode.getStep() != this.step) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("orderBy", this.orderBy).add("step", (Object)this.step).toString();
    }
}

