/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.sql.planner.assertions.AliasMatcher;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAlias;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.WindowFunctionMatcher;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.FunctionCall;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class WindowMatcher
implements Matcher {
    private final Optional<Set<SymbolAlias>> prePartitionedInputs;
    private final Optional<ExpectedValueProvider<WindowNode.Specification>> specification;
    private final Optional<Integer> preSortedOrderPrefix;
    private final Optional<Optional<SymbolAlias>> hashSymbol;

    private WindowMatcher(Optional<Set<SymbolAlias>> prePartitionedInputs, Optional<ExpectedValueProvider<WindowNode.Specification>> specification, Optional<Integer> preSortedOrderPrefix, Optional<Optional<SymbolAlias>> hashSymbol) {
        this.prePartitionedInputs = Objects.requireNonNull(prePartitionedInputs, "prePartitionedInputs is null");
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.preSortedOrderPrefix = Objects.requireNonNull(preSortedOrderPrefix, "preSortedOrderPrefix is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof WindowNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        WindowNode windowNode = (WindowNode)node;
        if (!this.prePartitionedInputs.map(expectedInputs -> ((ImmutableSet)expectedInputs.stream().map(alias -> alias.toSymbol(symbolAliases)).collect(ImmutableSet.toImmutableSet())).equals((Object)windowNode.getPrePartitionedInputs())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.specification.map(expectedSpecification -> ((WindowNode.Specification)expectedSpecification.getExpectedValue(symbolAliases)).equals((Object)windowNode.getSpecification())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.preSortedOrderPrefix.map(windowNode.getPreSortedOrderPrefix()::equals).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.hashSymbol.map(expectedHashSymbol -> expectedHashSymbol.map(alias -> alias.toSymbol(symbolAliases)).equals(windowNode.getHashSymbol())).orElse(true).booleanValue()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("prePartitionedInputs", this.prePartitionedInputs.orElse(null)).add("specification", this.specification.orElse(null)).add("preSortedOrderPrefix", this.preSortedOrderPrefix.orElse(null)).add("hashSymbol", this.hashSymbol.orElse(null)).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<Set<SymbolAlias>> prePartitionedInputs = Optional.empty();
        private Optional<ExpectedValueProvider<WindowNode.Specification>> specification = Optional.empty();
        private Optional<Integer> preSortedOrderPrefix = Optional.empty();
        private List<AliasMatcher> windowFunctionMatchers = new LinkedList<AliasMatcher>();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder prePartitionedInputs(Set<String> prePartitionedInputs) {
            Objects.requireNonNull(prePartitionedInputs, "prePartitionedInputs is null");
            this.prePartitionedInputs = Optional.of(prePartitionedInputs.stream().map(SymbolAlias::new).collect(ImmutableSet.toImmutableSet()));
            return this;
        }

        public Builder specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
            return this.specification(PlanMatchPattern.specification(partitionBy, orderBy, orderings));
        }

        public Builder specification(ExpectedValueProvider<WindowNode.Specification> specification) {
            Objects.requireNonNull(specification, "specification is null");
            this.specification = Optional.of(specification);
            return this;
        }

        public Builder preSortedOrderPrefix(int preSortedOrderPrefix) {
            this.preSortedOrderPrefix = Optional.of(preSortedOrderPrefix);
            return this;
        }

        public Builder addFunction(String outputAlias, ExpectedValueProvider<FunctionCall> functionCall) {
            return this.addFunction(Optional.of(outputAlias), functionCall);
        }

        public Builder addFunction(ExpectedValueProvider<FunctionCall> functionCall) {
            return this.addFunction(Optional.empty(), functionCall);
        }

        private Builder addFunction(Optional<String> outputAlias, ExpectedValueProvider<FunctionCall> functionCall) {
            this.windowFunctionMatchers.add(new AliasMatcher(outputAlias, new WindowFunctionMatcher(functionCall, Optional.empty(), Optional.empty())));
            return this;
        }

        public Builder addFunction(String outputAlias, ExpectedValueProvider<FunctionCall> functionCall, Signature signature, ExpectedValueProvider<WindowNode.Frame> frame) {
            this.windowFunctionMatchers.add(new AliasMatcher(Optional.of(outputAlias), new WindowFunctionMatcher(functionCall, Optional.of(signature), Optional.of(frame))));
            return this;
        }

        public Builder hashSymbol() {
            this.hashSymbol = Optional.of(Optional.empty());
            return this;
        }

        public Builder hashSymbol(String hashSymbol) {
            Objects.requireNonNull(hashSymbol, "hashSymbol is null");
            this.hashSymbol = Optional.of(Optional.of(new SymbolAlias(hashSymbol)));
            return this;
        }

        PlanMatchPattern build() {
            PlanMatchPattern result = PlanMatchPattern.node(WindowNode.class, this.source).with(new WindowMatcher(this.prePartitionedInputs, this.specification, this.preSortedOrderPrefix, this.hashSymbol));
            this.windowFunctionMatchers.forEach(result::with);
            return result;
        }
    }
}

