/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.planner.RuleStatsRecorder;
import io.prestosql.sql.planner.iterative.IterativeOptimizer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIterativeOptimizer {
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("task_concurrency", "1").setSystemProperty("iterative_optimizer_enabled", "true").setSystemProperty("iterative_optimizer_timeout", "1ms");
        this.queryRunner = new LocalQueryRunner(sessionBuilder.build());
        this.queryRunner.createCatalog((String)this.queryRunner.getDefaultSession().getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }

    @Test(timeOut=1000L)
    public void optimizerTimeoutsOnNonConvergingPlan() {
        IterativeOptimizer optimizer = new IterativeOptimizer(new RuleStatsRecorder(), this.queryRunner.getStatsCalculator(), this.queryRunner.getCostCalculator(), (Set)ImmutableSet.of((Object)new NonConvergingRule()));
        try {
            this.queryRunner.inTransaction(arg_0 -> this.lambda$optimizerTimeoutsOnNonConvergingPlan$0((PlanOptimizer)optimizer, arg_0));
        }
        catch (PrestoException ex) {
            Assert.assertEquals((Object)ex.getErrorCode(), (Object)StandardErrorCode.OPTIMIZER_TIMEOUT.toErrorCode());
        }
    }

    private /* synthetic */ Object lambda$optimizerTimeoutsOnNonConvergingPlan$0(PlanOptimizer optimizer, Session transactionSession) {
        this.queryRunner.createPlan(transactionSession, "SELECT * FROM nation", (List)ImmutableList.of((Object)optimizer), WarningCollector.NOOP);
        Assert.fail((String)"The optimizer should not converge");
        return null;
    }

    private static class NonConvergingRule
    implements Rule<ProjectNode> {
        private NonConvergingRule() {
        }

        public Pattern<ProjectNode> getPattern() {
            return Patterns.project();
        }

        public Rule.Result apply(ProjectNode project, Captures captures, Rule.Context context) {
            if (NonConvergingRule.isIdentityProjection(project)) {
                return Rule.Result.ofPlanNode((PlanNode)project.getSource());
            }
            ProjectNode projectNode = new ProjectNode(context.getIdAllocator().getNextId(), (PlanNode)project, Assignments.identity((Iterable)project.getOutputSymbols()));
            return Rule.Result.ofPlanNode((PlanNode)projectNode);
        }

        private static boolean isIdentityProjection(ProjectNode project) {
            return ImmutableSet.copyOf((Collection)project.getOutputSymbols()).equals((Object)ImmutableSet.copyOf((Collection)project.getSource().getOutputSymbols()));
        }
    }
}

