/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.QueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=3)
@Warmup(iterations=10)
@Measurement(iterations=10)
public class BenchmarkReorderInterconnectedJoins {
    @Benchmark
    public MaterializedResult benchmarkReorderJoins(BenchmarkInfo benchmarkInfo) {
        return benchmarkInfo.getQueryRunner().execute(benchmarkInfo.getQuery());
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkReorderInterconnectedJoins.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkInfo {
        @Param(value={"ELIMINATE_CROSS_JOINS", "AUTOMATIC"})
        private String joinReorderingStrategy;
        @Param(value={"2", "4", "6", "8", "10"})
        private int numberOfTables;
        private String query;
        private LocalQueryRunner queryRunner;

        @Setup
        public void setup() {
            Preconditions.checkState((this.numberOfTables >= 2 ? 1 : 0) != 0, (Object)"numberOfTables must be >= 2");
            Session session = TestingSession.testSessionBuilder().setSystemProperty("join_reordering_strategy", this.joinReorderingStrategy).setSystemProperty("join_distribution_type", "AUTOMATIC").setCatalog("tpch").setSchema("tiny").build();
            this.queryRunner = new LocalQueryRunner(session);
            this.queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("EXPLAIN SELECT * FROM nation n1");
            for (int i = 2; i <= this.numberOfTables; ++i) {
                stringBuilder.append(String.format(" JOIN nation n%s ON n%s.nationkey = n%s.nationkey", i, i - 1, i));
            }
            this.query = stringBuilder.toString();
        }

        public String getQuery() {
            return this.query;
        }

        public QueryRunner getQueryRunner() {
            return this.queryRunner;
        }

        @TearDown
        public void tearDown() {
            this.queryRunner.close();
        }
    }
}

