/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.rule.CanonicalizeExpressions;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import org.testng.annotations.Test;

public class TestCanonicalizeExpressions
extends BaseRuleTest {
    private static final CanonicalizeExpressions canonicalizeExpressions = new CanonicalizeExpressions();

    public TestCanonicalizeExpressions() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireForExpressionsInCanonicalForm() {
        this.tester().assertThat(canonicalizeExpressions.filterExpressionRewrite()).on(p -> p.filter((Expression)BooleanLiteral.FALSE_LITERAL, (PlanNode)p.values(new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireForUnfilteredJoin() {
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireForCanonicalExpressions() {
        this.tester().assertThat(canonicalizeExpressions.joinExpressionRewrite()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new Symbol[0]), (PlanNode)p.values(new Symbol[0]), (Expression)BooleanLiteral.FALSE_LITERAL, new JoinNode.EquiJoinClause[0])).doesNotFire();
    }
}

