/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.cost.CostComparator;
import io.prestosql.cost.PlanNodeStatsEstimate;
import io.prestosql.cost.SymbolStatsEstimate;
import io.prestosql.cost.TaskCountEstimator;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.DetermineJoinDistributionType;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.iterative.rule.test.RuleAssert;
import io.prestosql.sql.planner.iterative.rule.test.RuleTester;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestDetermineJoinDistributionType {
    private static final CostComparator COST_COMPARATOR = new CostComparator(1.0, 1.0, 1.0);
    private static final int NODES_COUNT = 4;
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        this.tester = new RuleTester((List<Plugin>)ImmutableList.of(), (Map<String, String>)ImmutableMap.of(), Optional.of(4));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.tester.close();
        this.tester = null;
    }

    @Test
    public void testDetermineDistributionType() {
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.INNER, JoinNode.DistributionType.PARTITIONED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.INNER, JoinNode.DistributionType.REPLICATED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.INNER, JoinNode.DistributionType.PARTITIONED);
    }

    @Test
    public void testDetermineDistributionTypeForLeftOuter() {
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.LEFT, JoinNode.DistributionType.PARTITIONED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.LEFT, JoinNode.DistributionType.REPLICATED);
        this.testDetermineDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.LEFT, JoinNode.DistributionType.PARTITIONED);
    }

    private void testDetermineDistributionType(FeaturesConfig.JoinDistributionType sessionDistributedJoin, JoinNode.Type joinType, JoinNode.DistributionType expectedDistribution) {
        this.assertDetermineJoinDistributionType().on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(expectedDistribution), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testRepartitionRightOuter() {
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.PARTITIONED, JoinNode.Type.RIGHT);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.BROADCAST, JoinNode.Type.RIGHT);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.FULL);
        this.testRepartitionRightOuter(FeaturesConfig.JoinDistributionType.AUTOMATIC, JoinNode.Type.RIGHT);
    }

    private void testRepartitionRightOuter(FeaturesConfig.JoinDistributionType sessionDistributedJoin, JoinNode.Type joinType) {
        this.assertDetermineJoinDistributionType().on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", sessionDistributedJoin.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicateScalar() {
        this.assertDetermineJoinDistributionType().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.enforceSingleRow((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11")))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.enforceSingleRow(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)))));
    }

    @Test
    public void testReplicateNoEquiCriteria() {
        this.testReplicateNoEquiCriteria(JoinNode.Type.INNER);
        this.testReplicateNoEquiCriteria(JoinNode.Type.LEFT);
    }

    private void testReplicateNoEquiCriteria(JoinNode.Type joinType) {
        this.assertDetermineJoinDistributionType().on(p -> p.join(joinType, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.of(PlanBuilder.expression("A1 * B1 > 100")))).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(joinType, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.of("A1 * B1 > 100"), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testRetainDistributionType() {
        this.assertDetermineJoinDistributionType().on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("A1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("10"), PlanBuilder.expressions("11"))), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("B1")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("50"), PlanBuilder.expressions("11"))), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED))).doesNotFire();
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmaller() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateWhenOneTableMuchSmallerAndJoinCardinalityUnknown() {
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)SymbolStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)SymbolStatsEstimate.unknown())).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testPartitionWhenRequiredBySession() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 100;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6400.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.PARTITIONED.name()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("B1", "A1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0))));
    }

    @Test
    public void testPartitionWhenBothTablesEqual() {
        int aRows = 10000;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenRequiredBySession() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10000;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testPartitionFullOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.FULL, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.FULL, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testPartitionRightOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicateLeftOuterJoin() {
        int aRows = 10000;
        int bRows = 10;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.LEFT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoin() {
        int aRows = 10;
        int bRows = 1000000;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 100.0))).build()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testFlipAndReplicateRightOuterJoinWhenJoinCardinalityUnknown() {
        int aRows = 10;
        int bRows = 1000000;
        this.assertDetermineJoinDistributionType(new CostComparator(75.0, 10.0, 15.0)).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).overrideStats("valuesA", PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)SymbolStatsEstimate.unknown())).build()).overrideStats("valuesB", PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)SymbolStatsEstimate.unknown())).build()).on(p -> p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, p.symbol("A1", (Type)BigintType.BIGINT)), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, p.symbol("B1", (Type)BigintType.BIGINT)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(p.symbol("A1", (Type)BigintType.BIGINT), p.symbol("B1", (Type)BigintType.BIGINT))), (List<Symbol>)ImmutableList.of((Object)p.symbol("A1", (Type)BigintType.BIGINT), (Object)p.symbol("B1", (Type)BigintType.BIGINT)), Optional.empty())).matches(PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    @Test
    public void testReplicatesWhenNotRestricted() {
        VarcharType symbolType = VarcharType.createUnboundedVarcharType();
        int aRows = 10000;
        int bRows = 10;
        PlanNodeStatsEstimate probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        PlanNodeStatsEstimate buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 640000.0, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
        probeSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)aRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("A1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        buildSideStatsEstimate = PlanNodeStatsEstimate.builder().setOutputRowCount((double)bRows).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("B1"), (Object)new SymbolStatsEstimate(0.0, 100.0, 0.0, 6.4E9, 10.0))).build();
        this.assertDetermineJoinDistributionType().setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("join_max_broadcast_table_size", "100MB").overrideStats("valuesA", probeSideStatsEstimate).overrideStats("valuesB", buildSideStatsEstimate).on(p -> {
            Symbol a1 = p.symbol("A1", (Type)symbolType);
            Symbol b1 = p.symbol("B1", (Type)symbolType);
            return p.join(JoinNode.Type.INNER, (PlanNode)p.values(new PlanNodeId("valuesA"), aRows, a1), (PlanNode)p.values(new PlanNodeId("valuesB"), bRows, b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        }).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("A1", "B1")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"A1", (Object)0)), PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"B1", (Object)0))));
    }

    private RuleAssert assertDetermineJoinDistributionType() {
        return this.assertDetermineJoinDistributionType(COST_COMPARATOR);
    }

    private RuleAssert assertDetermineJoinDistributionType(CostComparator costComparator) {
        return this.tester.assertThat((Rule)new DetermineJoinDistributionType(costComparator, new TaskCountEstimator(() -> 4)));
    }
}

