/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.airlift.testing.Closeables;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.rule.ReorderJoins;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.io.Closeable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJoinNodeFlattener {
    private static final int DEFAULT_JOIN_LIMIT = 10;
    private LocalQueryRunner queryRunner;

    @BeforeClass
    public void setUp() {
        this.queryRunner = new LocalQueryRunner(TestingSession.testSessionBuilder().build());
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.queryRunner});
        this.queryRunner = null;
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testDoesNotAllowOuterJoin() {
        PlanBuilder p = this.planBuilder();
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        JoinNode outerJoin = p.join(JoinNode.Type.FULL, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)outerJoin, (Lookup)Lookup.noLookup(), (int)10);
    }

    @Test
    public void testDoesNotConvertNestedOuterJoins() {
        PlanBuilder p = this.planBuilder();
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol c1 = p.symbol("C1");
        JoinNode leftJoin = p.join(JoinNode.Type.LEFT, (PlanNode)p.values(a1), (PlanNode)p.values(b1), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ValuesNode valuesC = p.values(c1);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)leftJoin, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{leftJoin, valuesC}).setFilter((Expression)this.createEqualsExpression(a1, c1)).setOutputSymbols(new Symbol[]{a1, b1, c1}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10), (Object)expected);
    }

    @Test
    public void testRetainsOutputSymbols() {
        PlanBuilder p = this.planBuilder();
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol b2 = p.symbol("B2");
        Symbol c1 = p.symbol("C1");
        Symbol c2 = p.symbol("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<Symbol>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.empty()), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC}).setFilter(ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(b1, c1), this.createEqualsExpression(a1, b1)})).setOutputSymbols(new Symbol[]{a1, b1}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10), (Object)expected);
    }

    @Test
    public void testCombinesCriteriaAndFilters() {
        PlanBuilder p = this.planBuilder();
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol b2 = p.symbol("B2");
        Symbol c1 = p.symbol("C1");
        Symbol c2 = p.symbol("C2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1, b2);
        ValuesNode valuesC = p.values(c1, c2);
        Expression bcFilter = ExpressionUtils.and((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)c2.toSymbolReference(), (Expression)new LongLiteral("0")), new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)c2.toSymbolReference(), (Expression)new LongLiteral("7")), new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)b2.toSymbolReference(), (Expression)c2.toSymbolReference())});
        ComparisonExpression abcFilter = new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)a1.toSymbolReference(), (Expression)c1.toSymbolReference()), (Expression)b1.toSymbolReference());
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesB, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, c1)), (List<Symbol>)ImmutableList.of((Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(bcFilter)), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2), Optional.of(abcFilter));
        ReorderJoins.MultiJoinNode expected = new ReorderJoins.MultiJoinNode(new LinkedHashSet(ImmutableList.of((Object)valuesA, (Object)valuesB, (Object)valuesC)), ExpressionUtils.and((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)b1.toSymbolReference(), (Expression)c1.toSymbolReference()), new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)a1.toSymbolReference(), (Expression)b1.toSymbolReference()), bcFilter, abcFilter}), (List)ImmutableList.of((Object)a1, (Object)b1, (Object)b2, (Object)c1, (Object)c2));
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)10), (Object)expected);
    }

    @Test
    public void testConvertsBushyTrees() {
        PlanBuilder p = this.planBuilder();
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol c1 = p.symbol("C1");
        Symbol d1 = p.symbol("D1");
        Symbol d2 = p.symbol("D2");
        Symbol e1 = p.symbol("E1");
        Symbol e2 = p.symbol("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty()), (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty()), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<Symbol>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty()), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1, (Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{valuesA, valuesB, valuesC, valuesD, valuesE}).setFilter(ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(a1, b1), this.createEqualsExpression(a1, c1), this.createEqualsExpression(d1, e1), this.createEqualsExpression(d2, e2), this.createEqualsExpression(b1, e1)})).setOutputSymbols(new Symbol[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)5), (Object)expected);
    }

    @Test
    public void testMoreThanJoinLimit() {
        PlanBuilder p = this.planBuilder();
        Symbol a1 = p.symbol("A1");
        Symbol b1 = p.symbol("B1");
        Symbol c1 = p.symbol("C1");
        Symbol d1 = p.symbol("D1");
        Symbol d2 = p.symbol("D2");
        Symbol e1 = p.symbol("E1");
        Symbol e2 = p.symbol("E2");
        ValuesNode valuesA = p.values(a1);
        ValuesNode valuesB = p.values(b1);
        ValuesNode valuesC = p.values(c1);
        ValuesNode valuesD = p.values(d1, d2);
        ValuesNode valuesE = p.values(e1, e2);
        JoinNode join1 = p.join(JoinNode.Type.INNER, (PlanNode)valuesA, (PlanNode)valuesB, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, b1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1), Optional.empty());
        JoinNode join2 = p.join(JoinNode.Type.INNER, (PlanNode)valuesD, (PlanNode)valuesE, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(d1, e1), (Object)this.equiJoinClause(d2, e2)), (List<Symbol>)ImmutableList.of((Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        JoinNode joinNode = p.join(JoinNode.Type.INNER, (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)join1, (PlanNode)valuesC, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(a1, c1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1), Optional.empty()), (PlanNode)join2, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)this.equiJoinClause(b1, e1)), (List<Symbol>)ImmutableList.of((Object)a1, (Object)b1, (Object)c1, (Object)d1, (Object)d2, (Object)e1, (Object)e2), Optional.empty());
        ReorderJoins.MultiJoinNode expected = ReorderJoins.MultiJoinNode.builder().setSources(new PlanNode[]{join1, join2, valuesC}).setFilter(ExpressionUtils.and((Expression[])new Expression[]{this.createEqualsExpression(a1, c1), this.createEqualsExpression(b1, e1)})).setOutputSymbols(new Symbol[]{a1, b1, c1, d1, d2, e1, e2}).build();
        Assert.assertEquals((Object)ReorderJoins.MultiJoinNode.toMultiJoinNode((JoinNode)joinNode, (Lookup)Lookup.noLookup(), (int)2), (Object)expected);
    }

    private ComparisonExpression createEqualsExpression(Symbol left, Symbol right) {
        return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)left.toSymbolReference(), (Expression)right.toSymbolReference());
    }

    private JoinNode.EquiJoinClause equiJoinClause(Symbol symbol1, Symbol symbol2) {
        return new JoinNode.EquiJoinClause(symbol1, symbol2);
    }

    private PlanBuilder planBuilder() {
        return new PlanBuilder(new PlanNodeIdAllocator(), this.queryRunner.getMetadata());
    }
}

