/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneCountAggregationOverScalar;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneCountAggregationOverScalar
extends BaseRuleTest {
    public TestPruneCountAggregationOverScalar() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNonNestedAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.globalGrouping().addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())))).doesNotFire();
    }

    @Test
    public void testFiresOnNestedCountAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping().step(AggregationNode.Step.SINGLE).source((PlanNode)p.aggregation(aggregationBuilder -> aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())).globalGrouping().step(AggregationNode.Step.SINGLE))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverValues() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)p.symbol("orderkey")), (List<List<Expression>>)ImmutableList.of(PlanBuilder.expressions("1")))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testFiresOnCountAggregateOverEnforceSingleRow() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.enforceSingleRow((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))))).matches(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"count_1", (Object)0)));
    }

    @Test
    public void testDoesNotFireOnNestedCountAggregateWithNonEmptyGroupBy() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> p.aggregation(a -> a.addAggregation(p.symbol("count_1", (Type)BigintType.BIGINT), (Expression)new FunctionCall(QualifiedName.of((String)"count"), (List)ImmutableList.of()), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).step(AggregationNode.Step.SINGLE).globalGrouping().source((PlanNode)p.aggregation(aggregationBuilder -> {
            aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of())).groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of((Object)p.symbol("orderkey"))));
            aggregationBuilder.source((PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()));
        })))).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnNestedNonCountAggregate() {
        this.tester().assertThat((Rule)new PruneCountAggregationOverScalar()).on(p -> {
            Symbol totalPrice = p.symbol("total_price", (Type)DoubleType.DOUBLE);
            AggregationNode inner = p.aggregation(a -> a.addAggregation(totalPrice, (Expression)new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)new SymbolReference("totalprice"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).globalGrouping().source((PlanNode)p.project(Assignments.of((Symbol)totalPrice, (Expression)totalPrice.toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(new CatalogName("local"), (ConnectorTableHandle)new TpchTableHandle("orders", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.empty()), (List<Symbol>)ImmutableList.of((Object)totalPrice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)totalPrice, (Object)new TpchColumnHandle(totalPrice.getName(), (Type)DoubleType.DOUBLE))))));
            return p.aggregation(a -> a.addAggregation(p.symbol("sum_outer", (Type)DoubleType.DOUBLE), (Expression)new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)new SymbolReference("sum_inner"))), (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE)).globalGrouping().source((PlanNode)inner));
        }).doesNotFire();
    }
}

