/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneCrossJoinColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneCrossJoinColumns
extends BaseRuleTest {
    public TestPruneCrossJoinColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testLeftInputNotReferenced() {
        this.tester().assertThat((Rule)new PruneCrossJoinColumns()).on(p -> TestPruneCrossJoinColumns.buildProjectedCrossJoin(p, symbol -> symbol.getName().equals("rightValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"rightValue", (Object)PlanMatchPattern.expression("rightValue")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"leftValue"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rightValue"))).withExactOutputs("rightValue")));
    }

    @Test
    public void testRightInputNotReferenced() {
        this.tester().assertThat((Rule)new PruneCrossJoinColumns()).on(p -> TestPruneCrossJoinColumns.buildProjectedCrossJoin(p, symbol -> symbol.getName().equals("leftValue"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"leftValue", (Object)PlanMatchPattern.expression("leftValue")), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(), Optional.empty(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"leftValue")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of(), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"rightValue")))).withExactOutputs("leftValue")));
    }

    @Test
    public void testAllInputsReferenced() {
        this.tester().assertThat((Rule)new PruneCrossJoinColumns()).on(p -> TestPruneCrossJoinColumns.buildProjectedCrossJoin(p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private static PlanNode buildProjectedCrossJoin(PlanBuilder p, Predicate<Symbol> projectionFilter) {
        Symbol leftValue = p.symbol("leftValue");
        Symbol rightValue = p.symbol("rightValue");
        ImmutableList outputs = ImmutableList.of((Object)leftValue, (Object)rightValue);
        return p.project(Assignments.identity((Iterable)((Iterable)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(leftValue), (PlanNode)p.values(rightValue), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)outputs, Optional.empty(), Optional.empty(), Optional.empty()));
    }
}

