/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneIndexSourceColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.testng.annotations.Test;

public class TestPruneIndexSourceColumns
extends BaseRuleTest {
    public TestPruneIndexSourceColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneIndexSourceColumns()).on(p -> TestPruneIndexSourceColumns.buildProjectedIndexSource(p, symbol -> symbol.getName().equals("orderkey"))).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x", (Object)PlanMatchPattern.expression("orderkey")), PlanMatchPattern.constrainedIndexSource("orders", (Map<String, Domain>)ImmutableMap.of((Object)"totalprice", (Object)Domain.onlyNull((Type)DoubleType.DOUBLE)), (Map<String, String>)ImmutableMap.of((Object)"orderkey", (Object)"orderkey", (Object)"totalprice", (Object)"totalprice"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneIndexSourceColumns()).on(p -> TestPruneIndexSourceColumns.buildProjectedIndexSource(p, (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    private static PlanNode buildProjectedIndexSource(PlanBuilder p, Predicate<Symbol> projectionFilter) {
        Symbol orderkey = p.symbol("orderkey", (Type)IntegerType.INTEGER);
        Symbol custkey = p.symbol("custkey", (Type)IntegerType.INTEGER);
        Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
        TpchColumnHandle orderkeyHandle = new TpchColumnHandle(orderkey.getName(), (Type)IntegerType.INTEGER);
        TpchColumnHandle custkeyHandle = new TpchColumnHandle(custkey.getName(), (Type)IntegerType.INTEGER);
        TpchColumnHandle totalpriceHandle = new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE);
        return p.project(Assignments.identity((Iterable)((Iterable)ImmutableList.of((Object)orderkey, (Object)custkey, (Object)totalprice).stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.indexSource(new TableHandle(new CatalogName("local"), (ConnectorTableHandle)new TpchTableHandle("orders", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.empty()), (Set<Symbol>)ImmutableSet.of((Object)orderkey, (Object)custkey), (List<Symbol>)ImmutableList.of((Object)orderkey, (Object)custkey, (Object)totalprice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)orderkey, (Object)orderkeyHandle, (Object)custkey, (Object)custkeyHandle, (Object)totalprice, (Object)totalpriceHandle), (TupleDomain<ColumnHandle>)TupleDomain.fromFixedValues((Map)ImmutableMap.of((Object)totalpriceHandle, (Object)NullableValue.asNull((Type)DoubleType.DOUBLE)))));
    }
}

