/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneOrderByInAggregation;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.SortItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneOrderByInAggregation
extends BaseRuleTest {
    private static final FunctionRegistry functionRegistry = MetadataManager.createTestMetadataManager().getFunctionRegistry();

    public TestPruneOrderByInAggregation() {
        super(new Plugin[0]);
    }

    @Test
    public void testBasics() {
        this.tester().assertThat((Rule)new PruneOrderByInAggregation(functionRegistry)).on(this::buildAggregation).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("key"), (Map<Optional<String>, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(Optional.of("avg"), PlanMatchPattern.functionCall("avg", (List<String>)ImmutableList.of((Object)"input")), Optional.of("array_agg"), PlanMatchPattern.functionCall("array_agg", (List<String>)ImmutableList.of((Object)"input"), (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("input", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), (Map<Symbol, Symbol>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.values("input", "key", "keyHash", "mask")));
    }

    private AggregationNode buildAggregation(PlanBuilder planBuilder) {
        Symbol avg = planBuilder.symbol("avg");
        Symbol arrayAgg = planBuilder.symbol("array_agg");
        Symbol input = planBuilder.symbol("input");
        Symbol key = planBuilder.symbol("key");
        Symbol keyHash = planBuilder.symbol("keyHash");
        Symbol mask = planBuilder.symbol("mask");
        ImmutableList sourceSymbols = ImmutableList.of((Object)input, (Object)key, (Object)keyHash, (Object)mask);
        return planBuilder.aggregation(arg_0 -> TestPruneOrderByInAggregation.lambda$buildAggregation$0(key, avg, planBuilder, mask, arrayAgg, keyHash, (List)sourceSymbols, arg_0));
    }

    private static /* synthetic */ void lambda$buildAggregation$0(Symbol key, Symbol avg, PlanBuilder planBuilder, Symbol mask, Symbol arrayAgg, Symbol keyHash, List sourceSymbols, PlanBuilder.AggregationBuilder aggregationBuilder) {
        aggregationBuilder.singleGroupingSet(key).addAggregation(avg, PlanBuilder.expression("avg(input order by input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).addAggregation(arrayAgg, PlanBuilder.expression("array_agg(input order by input)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), mask).hashSymbol(keyHash).source((PlanNode)planBuilder.values(sourceSymbols, (List<List<Expression>>)ImmutableList.of()));
    }
}

