/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.type.DateType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PruneTableScanColumns;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestPruneTableScanColumns
extends BaseRuleTest {
    public TestPruneTableScanColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTableScanColumns()).on(p -> {
            Symbol orderdate = p.symbol("orderdate", (Type)DateType.DATE);
            Symbol totalprice = p.symbol("totalprice", (Type)DoubleType.DOUBLE);
            return p.project(Assignments.of((Symbol)p.symbol("x"), (Expression)totalprice.toSymbolReference()), (PlanNode)p.tableScan(new TableHandle(new CatalogName("local"), (ConnectorTableHandle)new TpchTableHandle("orders", 0.01), (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.empty()), (List<Symbol>)ImmutableList.of((Object)orderdate, (Object)totalprice), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)orderdate, (Object)new TpchColumnHandle(orderdate.getName(), (Type)DateType.DATE), (Object)totalprice, (Object)new TpchColumnHandle(totalprice.getName(), (Type)DoubleType.DOUBLE))));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"x_", (Object)PlanMatchPattern.expression("totalprice_")), PlanMatchPattern.strictTableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"totalprice_", (Object)"totalprice"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule)new PruneTableScanColumns()).on(p -> p.project(Assignments.of((Symbol)p.symbol("y"), (Expression)PlanBuilder.expression("x")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)p.symbol("x")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("x"), (Object)new TestingMetadata.TestingColumnHandle("x"))))).doesNotFire();
    }
}

