/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughOuterJoin;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import org.testng.annotations.Test;

public class TestPushLimitThroughOuterJoin
extends BaseRuleTest {
    public TestPushLimitThroughOuterJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushLimitThroughLeftJoin() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.join(JoinNode.Type.LEFT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.limit(1L, true, PlanMatchPattern.values("leftKey")), PlanMatchPattern.values("rightKey"))));
    }

    @Test
    public void testPushLimitThroughRightJoin() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.RIGHT, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).matches(PlanMatchPattern.limit(1L, PlanMatchPattern.join(JoinNode.Type.RIGHT, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("leftKey", "rightKey")), PlanMatchPattern.values("leftKey"), PlanMatchPattern.limit(1L, true, PlanMatchPattern.values("rightKey")))));
    }

    @Test
    public void testPushLimitThroughFullOuterJoin() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.FULL, (PlanNode)p.values(5, leftKey), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushWhenAlreadyLimited() {
        this.tester().assertThat((Rule)new PushLimitThroughOuterJoin()).on(p -> {
            Symbol leftKey = p.symbol("leftKey");
            Symbol rightKey = p.symbol("rightKey");
            return p.limit(1L, (PlanNode)p.join(JoinNode.Type.LEFT, (PlanNode)p.limit(1L, (PlanNode)p.values(5, leftKey)), (PlanNode)p.values(5, rightKey), new JoinNode.EquiJoinClause(leftKey, rightKey)));
        }).doesNotFire();
    }
}

