/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushLimitThroughProject;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushLimitThroughProject
extends BaseRuleTest {
    public TestPushLimitThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownLimitNonIdentityProjection() {
        this.tester().assertThat((Rule)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(new Symbol[0])));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("true")), PlanMatchPattern.limit(1L, PlanMatchPattern.values(new String[0]))));
    }

    @Test
    public void testDoesntPushdownLimitThroughIdentityProjection() {
        this.tester().assertThat((Rule)new PushLimitThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.limit(1L, (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }
}

