/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slices;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.TableHandle;
import io.prestosql.plugin.tpch.TpchColumnHandle;
import io.prestosql.plugin.tpch.TpchTableHandle;
import io.prestosql.plugin.tpch.TpchTableLayoutHandle;
import io.prestosql.plugin.tpch.TpchTransactionHandle;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushPredicateIntoTableScan;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPushPredicateIntoTableScan
extends BaseRuleTest {
    private PushPredicateIntoTableScan pushPredicateIntoTableScan;
    private TableHandle nationTableHandle;
    private TableHandle ordersTableHandle;
    private CatalogName catalogName;

    public TestPushPredicateIntoTableScan() {
        super(new Plugin[0]);
    }

    @BeforeClass
    public void setUpBeforeClass() {
        this.pushPredicateIntoTableScan = new PushPredicateIntoTableScan(this.tester().getMetadata(), new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()));
        this.catalogName = this.tester().getCurrentConnectorId();
        TpchTableHandle nation = new TpchTableHandle("nation", 1.0);
        this.nationTableHandle = new TableHandle(this.catalogName, (ConnectorTableHandle)nation, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(nation, TupleDomain.all())));
        TpchTableHandle orders = new TpchTableHandle("orders", 1.0);
        this.ordersTableHandle = new TableHandle(this.catalogName, (ConnectorTableHandle)orders, (ConnectorTransactionHandle)TpchTransactionHandle.INSTANCE, Optional.of(new TpchTableLayoutHandle(orders, TupleDomain.all())));
    }

    @Test
    public void doesNotFireIfNoTableScan() {
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(p -> p.values(p.symbol("a", (Type)BigintType.BIGINT))).doesNotFire();
    }

    @Test
    public void eliminateTableScanWhenNoLayoutExist() {
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'G'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void replaceWithExistsWhenNoLayoutExist() {
        TpchColumnHandle columnHandle = new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT);
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$replaceWithExistsWhenNoLayoutExist$2((ColumnHandle)columnHandle, arg_0)).matches(PlanMatchPattern.values("A"));
    }

    @Test
    public void doesNotFireIfRuleNotChangePlan() {
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("nationkey % 17 =  BIGINT '44' AND nationkey % 15 =  BIGINT '43'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT)), (TupleDomain<ColumnHandle>)TupleDomain.all()))).doesNotFire();
    }

    @Test
    public void ruleAddedTableLayoutToFilterTableScan() {
        ImmutableMap filterConstraint = ImmutableMap.builder().put((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))).build();
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = CAST ('F' AS VARCHAR(1))"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)filterConstraint, (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void ruleAddedNewTableLayoutIfTableScanHasEmptyConstraint() {
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(p -> p.filter(PlanBuilder.expression("orderstatus = 'F'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", (Type)VarcharType.createVarcharType((int)1)), (Object)new TpchColumnHandle("orderstatus", (Type)VarcharType.createVarcharType((int)1)))))).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)VarcharType.createVarcharType((int)1), (Object)Slices.utf8Slice((String)"F"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void ruleWithPushdownableToTableLayoutPredicate() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$ruleWithPushdownableToTableLayoutPredicate$6((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus")));
    }

    @Test
    public void nonDeterministicPredicate() {
        VarcharType orderStatusType = VarcharType.createVarcharType((int)1);
        this.tester().assertThat((Rule)this.pushPredicateIntoTableScan).on(arg_0 -> this.lambda$nonDeterministicPredicate$7((Type)orderStatusType, arg_0)).matches(PlanMatchPattern.filter("rand() = 0", PlanMatchPattern.constrainedTableScanWithTableLayout("orders", (Map<String, Domain>)ImmutableMap.of((Object)"orderstatus", (Object)Domain.singleValue((Type)orderStatusType, (Object)Slices.utf8Slice((String)"O"))), (Map<String, String>)ImmutableMap.of((Object)"orderstatus", (Object)"orderstatus"))));
    }

    private /* synthetic */ PlanNode lambda$nonDeterministicPredicate$7(Type orderStatusType, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("orderstatus = 'O' AND rand() = 0"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$ruleWithPushdownableToTableLayoutPredicate$6(Type orderStatusType, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("orderstatus = 'O'"), (PlanNode)p.tableScan(this.ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("orderstatus", orderStatusType)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("orderstatus", orderStatusType), (Object)new TpchColumnHandle("orderstatus", orderStatusType))));
    }

    private /* synthetic */ PlanNode lambda$replaceWithExistsWhenNoLayoutExist$2(ColumnHandle columnHandle, PlanBuilder p) {
        return p.filter(PlanBuilder.expression("nationkey = BIGINT '44'"), (PlanNode)p.tableScan(this.nationTableHandle, (List<Symbol>)ImmutableList.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("nationkey", (Type)BigintType.BIGINT), (Object)columnHandle), (TupleDomain<ColumnHandle>)TupleDomain.none()));
    }
}

