/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.ExpressionMatcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.PushTopNThroughProject;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SortItem;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPushTopNThroughProject
extends BaseRuleTest {
    public TestPushTopNThroughProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testPushdownTopNNonIdentityProjection() {
        this.tester().assertThat((Rule)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedB = p.symbol("projectedB");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedB, (Expression)new SymbolReference("b")), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedB", (Object)new ExpressionMatcher("b")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testPushdownTopNNonIdentityProjectionWithExpression() {
        this.tester().assertThat((Rule)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            Symbol projectedC = p.symbol("projectedC");
            Symbol b = p.symbol("b");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a"), (Symbol)projectedC, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b"))), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"projectedA", (Object)new ExpressionMatcher("a"), (Object)"projectedC", (Object)new ExpressionMatcher("a + b")), PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("a", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testDoNotPushdownTopNThroughIdentityProjection() {
        this.tester().assertThat((Rule)new PushTopNThroughProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.project(Assignments.of((Symbol)a, (Expression)a.toSymbolReference()), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushdownTopNThroughProjectionOverFilterOverTableScan() {
        this.tester().assertThat((Rule)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a")), (PlanNode)p.filter((Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of(), (Map<Symbol, ColumnHandle>)ImmutableMap.of()))));
        }).doesNotFire();
    }

    @Test
    public void testDoNotPushdownTopNThroughProjectionOverTableScan() {
        this.tester().assertThat((Rule)new PushTopNThroughProject()).on(p -> {
            Symbol projectedA = p.symbol("projectedA");
            Symbol a = p.symbol("a");
            return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)projectedA), (PlanNode)p.project(Assignments.of((Symbol)projectedA, (Expression)new SymbolReference("a")), (PlanNode)p.tableScan((List<Symbol>)ImmutableList.of((Object)a), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)a, (Object)new TestingMetadata.TestingColumnHandle("a")))));
        }).doesNotFire();
    }
}

