/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.RemoveAggregationInSemiJoin;
import io.prestosql.sql.planner.iterative.rule.test.BaseRuleTest;
import io.prestosql.sql.planner.iterative.rule.test.PlanBuilder;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestRemoveAggregationInSemiJoin
extends BaseRuleTest {
    public TestRemoveAggregationInSemiJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void test() {
        this.tester().assertThat((Rule)new RemoveAggregationInSemiJoin()).on(TestRemoveAggregationInSemiJoin::semiJoinWithDistinctAsFilteringSource).matches(PlanMatchPattern.semiJoin("leftKey", "rightKey", "match", PlanMatchPattern.values("leftKey"), PlanMatchPattern.values("rightKey")));
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule)new RemoveAggregationInSemiJoin()).on(TestRemoveAggregationInSemiJoin::semiJoinWithAggregationAsFilteringSource).doesNotFire();
    }

    private static PlanNode semiJoinWithDistinctAsFilteringSource(PlanBuilder p) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol rightKey = p.symbol("rightKey");
        return p.semiJoin(leftKey, rightKey, p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(leftKey), (PlanNode)p.aggregation(builder -> builder.singleGroupingSet(rightKey).source((PlanNode)p.values(rightKey))));
    }

    private static PlanNode semiJoinWithAggregationAsFilteringSource(PlanBuilder p) {
        Symbol leftKey = p.symbol("leftKey");
        Symbol rightKey = p.symbol("rightKey");
        return p.semiJoin(leftKey, rightKey, p.symbol("match"), Optional.empty(), Optional.empty(), (PlanNode)p.values(leftKey), (PlanNode)p.aggregation(builder -> builder.globalGrouping().addAggregation(rightKey, PlanBuilder.expression("count(rightValue)"), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("rightValue")))));
    }
}

