/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.Metadata;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.split.PageSourceManager;
import io.prestosql.split.SplitManager;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.test.RuleAssert;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TransactionManager;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RuleTester
implements Closeable {
    public static final String CATALOG_ID = "local";
    public static final CatalogName CONNECTOR_ID = new CatalogName("local");
    private final Metadata metadata;
    private final Session session;
    private final LocalQueryRunner queryRunner;
    private final TransactionManager transactionManager;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final AccessControl accessControl;
    private final TypeAnalyzer typeAnalyzer;

    public RuleTester() {
        this(Collections.emptyList());
    }

    public RuleTester(List<Plugin> plugins) {
        this(plugins, (Map<String, String>)ImmutableMap.of());
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties) {
        this(plugins, sessionProperties, Optional.empty());
    }

    public RuleTester(List<Plugin> plugins, Map<String, String> sessionProperties, Optional<Integer> nodeCountForStats) {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(CATALOG_ID).setSchema("tiny").setSystemProperty("task_concurrency", "1");
        for (Map.Entry<String, String> entry : sessionProperties.entrySet()) {
            sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
        }
        this.session = sessionBuilder.build();
        this.queryRunner = nodeCountForStats.map(nodeCount -> LocalQueryRunner.queryRunnerWithFakeNodeCountForStats((Session)this.session, (int)nodeCount)).orElseGet(() -> new LocalQueryRunner(this.session));
        this.queryRunner.createCatalog((String)this.session.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        plugins.stream().forEach(arg_0 -> ((LocalQueryRunner)this.queryRunner).installPlugin(arg_0));
        this.metadata = this.queryRunner.getMetadata();
        this.transactionManager = this.queryRunner.getTransactionManager();
        this.splitManager = this.queryRunner.getSplitManager();
        this.pageSourceManager = this.queryRunner.getPageSourceManager();
        this.accessControl = this.queryRunner.getAccessControl();
        this.typeAnalyzer = new TypeAnalyzer(this.queryRunner.getSqlParser(), this.metadata);
    }

    public RuleAssert assertThat(Rule rule) {
        return new RuleAssert(this.metadata, this.queryRunner.getStatsCalculator(), this.queryRunner.getEstimatedExchangesCostCalculator(), this.session, rule, this.transactionManager, this.accessControl);
    }

    @Override
    public void close() {
        this.queryRunner.close();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public TypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    public CatalogName getCurrentConnectorId() {
        return (CatalogName)((Optional)this.queryRunner.inTransaction(transactionSession -> this.metadata.getCatalogHandle(transactionSession, (String)this.session.getCatalog().get()))).get();
    }
}

