/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.Test;

public class TestAddExchangesPlans
extends BasePlanTest {
    public TestAddExchangesPlans() {
        super(TestAddExchangesPlans::createQueryRunner);
    }

    private static LocalQueryRunner createQueryRunner() {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        FeaturesConfig featuresConfig = new FeaturesConfig().setSpillerSpillPaths("/tmp/test_spill_path");
        LocalQueryRunner queryRunner = new LocalQueryRunner(session, featuresConfig);
        queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testRepartitionForUnionWithAnyTableScans() {
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select regionkey from region", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region"))))))));
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values(new String[0]))))))));
    }

    @Test
    public void testRepartitionForUnionAllBeforeHashJoin() {
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select nationkey from nation) n join region r on n.nationkey = r.regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select 1) n join region r on n.nationkey = r.regionkey", PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values(new String[0])))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testNonSpillableBroadcastJoinAboveTableScan() {
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.spillEnabledWithJoinDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), Optional.of(false), PlanMatchPattern.anyNot(ExchangeNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.spillEnabledWithJoinDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), Optional.empty(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    private Session spillEnabledWithJoinDistributionType(FeaturesConfig.JoinDistributionType joinDistributionType) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", joinDistributionType.toString()).setSystemProperty("spill_enabled", "true").setSystemProperty("task_concurrency", "16").build();
    }
}

