/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import io.prestosql.Session;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.TopNRowNumberNode;
import io.prestosql.sql.planner.plan.WindowNode;
import org.testng.annotations.Test;

public class TestWindowFilterPushDown
extends BasePlanTest {
    @Test
    public void testLimitAboveWindow() {
        String sql = "SELECT row_number() OVER (PARTITION BY suppkey ORDER BY orderkey) partition_row_number FROM lineitem LIMIT 10";
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.node(TopNRowNumberNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(false), true, PlanMatchPattern.anyTree(PlanMatchPattern.limit(10L, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
    }

    @Test
    public void testFilterAboveWindow() {
        String sql = "SELECT * FROM (SELECT row_number() OVER (PARTITION BY suppkey ORDER BY orderkey) partition_row_number FROM lineitem) WHERE partition_row_number < 10";
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(true), true, PlanMatchPattern.anyTree(PlanMatchPattern.anyNot(FilterNode.class, PlanMatchPattern.node(TopNRowNumberNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem"))))));
        this.assertPlanWithSession(sql, this.optimizeTopNRowNumber(false), true, PlanMatchPattern.anyTree(PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.node(WindowNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("lineitem")))))));
    }

    private Session optimizeTopNRowNumber(boolean enabled) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("optimize_top_n_row_number", Boolean.toString(enabled)).build();
    }
}

