/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Signature;
import io.prestosql.server.SliceDeserializer;
import io.prestosql.server.SliceSerializer;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.Serialization;
import io.prestosql.sql.parser.SqlParser;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FrameBound;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.WindowFrame;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestWindowNode {
    private SymbolAllocator symbolAllocator;
    private ValuesNode sourceNode;
    private Symbol columnA;
    private Symbol columnB;
    private Symbol columnC;
    private final ObjectMapper objectMapper;

    public TestWindowNode() {
        SqlParser sqlParser = new SqlParser();
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonSerializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceSerializer(), Expression.class, (Object)new Serialization.ExpressionSerializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Slice.class, (Object)new SliceDeserializer(), Expression.class, (Object)new Serialization.ExpressionDeserializer(sqlParser), FunctionCall.class, (Object)new Serialization.FunctionCallDeserializer(sqlParser)));
        this.objectMapper = provider.get();
    }

    @BeforeClass
    public void setUp() {
        this.symbolAllocator = new SymbolAllocator();
        this.columnA = this.symbolAllocator.newSymbol("a", (Type)BigintType.BIGINT);
        this.columnB = this.symbolAllocator.newSymbol("b", (Type)BigintType.BIGINT);
        this.columnC = this.symbolAllocator.newSymbol("c", (Type)BigintType.BIGINT);
        this.sourceNode = new ValuesNode(TestWindowNode.newId(), (List)ImmutableList.of((Object)this.columnA, (Object)this.columnB, (Object)this.columnC), (List)ImmutableList.of());
    }

    @Test
    public void testSerializationRoundtrip() throws Exception {
        Symbol windowSymbol = this.symbolAllocator.newSymbol("sum", (Type)BigintType.BIGINT);
        Signature signature = new Signature("sum", FunctionKind.WINDOW, (List)ImmutableList.of(), (List)ImmutableList.of(), BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()), false);
        FunctionCall functionCall = new FunctionCall(QualifiedName.of((String)"sum"), (List)ImmutableList.of((Object)this.columnC.toSymbolReference()));
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty(), Optional.empty());
        PlanNodeId id = TestWindowNode.newId();
        WindowNode.Specification specification = new WindowNode.Specification((List)ImmutableList.of((Object)this.columnA), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)this.columnB), (Map)ImmutableMap.of((Object)this.columnB, (Object)SortOrder.ASC_NULLS_FIRST))));
        ImmutableMap functions = ImmutableMap.of((Object)windowSymbol, (Object)new WindowNode.Function(functionCall, signature, frame));
        Optional<Symbol> hashSymbol = Optional.of(this.columnB);
        ImmutableSet prePartitionedInputs = ImmutableSet.of((Object)this.columnA);
        WindowNode windowNode = new WindowNode(id, (PlanNode)this.sourceNode, specification, (Map)functions, hashSymbol, (Set)prePartitionedInputs, 0);
        String json = this.objectMapper.writeValueAsString((Object)windowNode);
        WindowNode actualNode = (WindowNode)this.objectMapper.readValue(json, WindowNode.class);
        Assert.assertEquals((Object)actualNode.getId(), (Object)windowNode.getId());
        Assert.assertEquals((Object)actualNode.getSpecification(), (Object)windowNode.getSpecification());
        Assert.assertEquals((Map)actualNode.getWindowFunctions(), (Map)windowNode.getWindowFunctions());
        Assert.assertEquals((Collection)actualNode.getFrames(), (Collection)windowNode.getFrames());
        Assert.assertEquals((Object)actualNode.getHashSymbol(), (Object)windowNode.getHashSymbol());
        Assert.assertEquals((Set)actualNode.getPrePartitionedInputs(), (Set)windowNode.getPrePartitionedInputs());
        Assert.assertEquals((int)actualNode.getPreSortedOrderPrefix(), (int)windowNode.getPreSortedOrderPrefix());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }
}

